/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.util.FacesLogger;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DbfFactory {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACES_1_2_XSD = "/com/sun/faces/web-facesconfig_1_2.xsd";
    private static final String FACES_1_1_XSD = "/com/sun/faces/web-facesconfig_1_1.xsd";
    private static Schema FACES_12_SCHEMA;
    private static Schema FACES_11_SCHEMA;
    public static final EntityResolver FACES_ENTITY_RESOLVER;
    public static final FacesErrorHandler FACES_ERROR_HANDLER;

    public static DocumentBuilderFactory getFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        return factory;
    }

    private static void initSchema() {
        try {
            URL url = DbfFactory.class.getResource(FACES_1_2_XSD);
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            InputStream in = conn.getInputStream();
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
            FACES_12_SCHEMA = factory.newSchema(new StreamSource(in));
            url = DbfFactory.class.getResource(FACES_1_1_XSD);
            conn = url.openConnection();
            conn.setUseCaches(false);
            in = conn.getInputStream();
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
            FACES_11_SCHEMA = factory.newSchema(new StreamSource(in));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    static /* synthetic */ Schema access$000() {
        return FACES_12_SCHEMA;
    }

    static /* synthetic */ Schema access$100() {
        return FACES_11_SCHEMA;
    }

    static {
        FACES_ENTITY_RESOLVER = new FacesEntityResolver();
        FACES_ERROR_HANDLER = new FacesErrorHandler();
        DbfFactory.initSchema();
    }

    private static final class Input
    implements LSInput {
        InputStream in;

        public Input(InputStream in) {
            this.in = in;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return this.in;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }

    private static class FacesErrorHandler
    implements ErrorHandler {
        private FacesErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static class FacesEntityResolver
    extends DefaultHandler
    implements LSResourceResolver {
        private static final String[][] DTD_SCHEMA_INFO = new String[][]{{"web-facesconfig_1_0.dtd", "/com/sun/faces/web-facesconfig_1_0.dtd"}, {"web-facesconfig_1_1.dtd", "/com/sun/faces/web-facesconfig_1_1.dtd"}, {"web-facesconfig_1_2.xsd", "/com/sun/faces/web-facesconfig_1_2.xsd"}, {"web-facesconfig_1_1.xsd", "/com/sun/faces/web-facesconfig_1_1.xsd"}, {"javaee_5.xsd", "/com/sun/faces/javaee_5.xsd"}, {"javaee_web_services_client_1_2.xsd", "/com/sun/faces/javaee_web_services_client_1_2.xsd"}, {"xml.xsd", "/com/sun/faces/xml.xsd"}, {"datatypes.dtd", "/com/sun/faces/datatypes.dtd"}, {"XMLSchema.dtd", "/com/sun/faces/XMLSchema.dtd"}};
        private HashMap<String, String> entities = new HashMap(6, 1.0f);

        public FacesEntityResolver() {
            for (String[] aDTD_SCHEMA_INFO : DTD_SCHEMA_INFO) {
                URL url = this.getClass().getResource(aDTD_SCHEMA_INFO[1]);
                if (url == null) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.config.cannot_resolve_entities", new Object[]{aDTD_SCHEMA_INFO[1], aDTD_SCHEMA_INFO[0]});
                    continue;
                }
                this.entities.put(aDTD_SCHEMA_INFO[0], url.toString());
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputSource source;
            if (systemId == null) {
                InputSource result;
                try {
                    result = super.resolveEntity(publicId, null);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
                return result;
            }
            String grammarName = systemId.substring(systemId.lastIndexOf(47) + 1);
            String entityURL = this.entities.get(grammarName);
            if (entityURL == null) {
                LOGGER.log(Level.FINE, "Unknown entity, deferring to superclass.");
                try {
                    source = super.resolveEntity(publicId, systemId);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            try {
                source = new InputSource(new URL(entityURL).openStream());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "jsf.config.cannot_create_inputsource", entityURL);
                source = null;
            }
            if (source != null) {
                source.setSystemId(entityURL);
                if (publicId != null) {
                    source.setPublicId(publicId);
                }
            }
            return source;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                InputSource source = this.resolveEntity(publicId, systemId);
                if (source != null) {
                    return new Input(source.getByteStream());
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            return null;
        }

        public Map<String, String> getKnownEntities() {
            return Collections.unmodifiableMap(this.entities);
        }
    }

    public static enum FacesSchema {
        FACES_12(DbfFactory.access$000()),
        FACES_11(DbfFactory.access$100());

        private Schema schema;

        private FacesSchema(Schema schema) {
            this.schema = schema;
        }

        public Schema getSchema() {
            return this.schema;
        }
    }
}

