/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.AuthenticationCacheFlushThread;
import org.jboss.security.auth.AuthenticationTimedCachePolicy;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.integration.SecurityActions;
import org.jboss.security.integration.SecurityConstantsBridge;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.plugins.JaasSecurityDomain;
import org.jboss.security.plugins.SecurityDomainContext;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

@ManagementObject(name="JNDIBasedSecurityManagement", componentType=@ManagementComponent(type="MCBean", subtype="Security"), properties=ManagementProperties.EXPLICIT)
public class JNDIBasedSecurityManagement
implements ISecurityManagement {
    private static final long serialVersionUID = 1L;
    public static final String CBH = "org.jboss.security.callbackhandler";
    protected static Logger log = Logger.getLogger(JNDIBasedSecurityManagement.class);
    static transient ConcurrentHashMap<String, SecurityDomainContext> securityMgrMap = new ConcurrentHashMap();
    protected String BASE_CTX = "java:/jaas";
    protected String authenticationMgrClass = "org.jboss.security.plugins.JaasSecurityManager";
    protected String authorizationMgrClass = "org.jboss.security.plugins.JBossAuthorizationManager";
    protected String auditMgrClass = "org.jboss.security.plugins.audit.JBossAuditManager";
    protected String identityTrustMgrClass = "org.jboss.security.plugins.identitytrust.JBossIdentityTrustManager";
    protected String mappingMgrClass = "org.jboss.security.plugins.mapping.JBossMappingManager";
    protected static transient CallbackHandler callBackHandler = new JBossCallbackHandler();
    protected boolean enableIdentity = false;
    protected boolean enableAudit = true;
    private CachePolicy cachePolicy = null;
    private transient ConcurrentHashMap<String, AuthenticationManager> authMgrMap = null;
    private transient ConcurrentHashMap<String, AuthorizationManager> authzMgrMap = null;
    private transient ConcurrentHashMap<String, MappingManager> mappingMgrMap = null;
    private transient ConcurrentHashMap<String, AuditManager> auditMgrMap = null;
    private transient ConcurrentHashMap<String, IdentityTrustManager> idmMgrMap = null;
    private static AuthenticationCacheFlushThread authCacheFlushThread;

    public JNDIBasedSecurityManagement() {
        this.initialize();
        this.initializeCallbackHandler();
    }

    @ManagementOperation(description="Get the audit manager for the specified security domain", params={@ManagementParameter(name="securityDomain", description="The security domain name")})
    public AuditManager getAuditManager(String securityDomain) {
        this.initialize();
        AuditManager auditManager = null;
        try {
            if (this.enableAudit && (auditManager = this.auditMgrMap.get(securityDomain)) == null) {
                auditManager = (AuditManager)this.lookUpJNDI(securityDomain + "/auditMgr");
                this.auditMgrMap.put(securityDomain, auditManager);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting audit mgr", (Throwable)e);
        }
        return auditManager;
    }

    @ManagementOperation(description="Get the authentication manager for the specified security domain", params={@ManagementParameter(name="securityDomain", description="The security domain name")})
    public AuthenticationManager getAuthenticationManager(String securityDomain) {
        this.initialize();
        AuthenticationManager am = null;
        try {
            am = this.authMgrMap.get(securityDomain);
            if (am == null) {
                am = (AuthenticationManager)this.lookUpJNDI(securityDomain + "/authenticationMgr");
                this.authMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            log.trace((Object)("Exception in getting authentication mgr  for domain=" + securityDomain), (Throwable)e);
        }
        return am;
    }

    @ManagementOperation(description="Get the authorization manager for the specified security domain", params={@ManagementParameter(name="securityDomain", description="The security domain name")})
    public AuthorizationManager getAuthorizationManager(String securityDomain) {
        this.initialize();
        AuthorizationManager am = null;
        try {
            am = this.authzMgrMap.get(securityDomain);
            if (am == null) {
                am = (AuthorizationManager)this.lookUpJNDI(securityDomain + "/authorizationMgr");
                this.authzMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting authorization mgr", (Throwable)e);
        }
        return am;
    }

    @ManagementOperation(description="Get the identity trust manager for the specified security domain", params={@ManagementParameter(name="securityDomain", description="The security domain name")})
    public IdentityTrustManager getIdentityTrustManager(String securityDomain) {
        this.initialize();
        IdentityTrustManager am = null;
        try {
            if (this.enableIdentity && (am = this.idmMgrMap.get(securityDomain)) == null) {
                am = (IdentityTrustManager)this.lookUpJNDI(securityDomain + "/identityTrustMgr");
                this.idmMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting IdentityTrustManager", (Throwable)e);
        }
        return am;
    }

    @ManagementOperation(description="Get the mapping manager for the specified security domain", params={@ManagementParameter(name="securityDomain", description="The security domain name")})
    public MappingManager getMappingManager(String securityDomain) {
        this.initialize();
        MappingManager am = null;
        try {
            am = this.mappingMgrMap.get(securityDomain);
            if (am == null) {
                am = (MappingManager)this.lookUpJNDI(securityDomain + "/mappingMgr");
                if (am == null) {
                    am = this.createMappingManager(securityDomain);
                }
                this.mappingMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting MappingManager", (Throwable)e);
        }
        return am;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The class that implements the AuthenticationManager interface")
    public void setAuthenticationMgrClass(String authenticationMgrClass) {
        this.authenticationMgrClass = authenticationMgrClass;
        securityMgrMap.clear();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The class that implements the AuthorizationManager interface")
    public void setAuthorizationMgrClass(String authorizationMgrClass) {
        this.authorizationMgrClass = authorizationMgrClass;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The class that implements the AuditManager interface")
    public void setAuditMgrClass(String auditMgrClass) {
        this.auditMgrClass = auditMgrClass;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The class that implements the IdentityTrustManager interface")
    public void setIdentityTrustMgrClass(String identityTrustMgrClass) {
        this.identityTrustMgrClass = identityTrustMgrClass;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The class that implements the MappingManager interface")
    public void setMappingMgrClass(String mappingMgrClass) {
        this.mappingMgrClass = mappingMgrClass;
    }

    public void setCallBackHandler(CallbackHandler cbh) {
        callBackHandler = cbh;
        securityMgrMap.clear();
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public void setEnableIdentity(boolean enableIdentity) {
        this.enableIdentity = enableIdentity;
    }

    public void setCachePolicy(CachePolicy cp) {
        this.cachePolicy = cp;
    }

    public void setBaseContext(String ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is null");
        }
        this.BASE_CTX = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCacheTimeout(String securityDomain, int timeoutInSecs, int resInSecs) {
        SecurityDomainContext securityDomainCtx = securityMgrMap.get(securityDomain);
        if (securityDomainCtx == null) {
            try {
                String lookupStr = "java:/jaas/" + securityDomain;
                securityDomainCtx = (SecurityDomainContext)new InitialContext().lookup(lookupStr);
                securityMgrMap.put(securityDomain, securityDomainCtx);
            }
            catch (NamingException e) {
                log.trace((Object)("SetCacheTimeOut:Failed to look up SecurityDomainCtx:" + securityDomain));
            }
        }
        if (securityDomainCtx != null) {
            CachePolicy cache = securityDomainCtx.getAuthenticationCache();
            if (cache != null && cache instanceof TimedCachePolicy) {
                TimedCachePolicy tcp;
                TimedCachePolicy timedCachePolicy = tcp = (TimedCachePolicy)cache;
                synchronized (timedCachePolicy) {
                    tcp.setDefaultLifetime(timeoutInSecs);
                    tcp.setResolution(resInSecs);
                }
            } else {
                log.warn((Object)("Failed to find cache policy for securityDomain='" + securityDomain + "'"));
            }
        }
    }

    public static void setDefaultCacheTimeout(int defaultCacheTimeout) {
        SecurityConstantsBridge.defaultCacheTimeout = defaultCacheTimeout;
    }

    public static void setDefaultCacheResolution(int defaultCacheResolution) {
        SecurityConstantsBridge.defaultCacheResolution = defaultCacheResolution;
    }

    public static void setDefaultCacheFlushPeriod(int flushPeriodInSecs) {
        SecurityConstantsBridge.defaultCacheFlushPeriod = flushPeriodInSecs;
        if (SecurityConstantsBridge.defaultCacheFlushPeriod == 0 && authCacheFlushThread != null) {
            authCacheFlushThread.interrupt();
            authCacheFlushThread = null;
        }
        if (SecurityConstantsBridge.defaultCacheFlushPeriod > 0 && authCacheFlushThread == null) {
            authCacheFlushThread = new AuthenticationCacheFlushThread(securityMgrMap);
            authCacheFlushThread.start();
        }
    }

    @ManagementOperation(description="Create the context for the specified security domain", params={@ManagementParameter(name="securityDomain", description="The security domain name")})
    public SecurityDomainContext createSecurityDomainContext(String securityDomain) throws Exception {
        log.debug((Object)("Creating SDC for domain=" + securityDomain));
        AuthenticationManager am = this.createAuthenticationManager(securityDomain);
        CachePolicy cache = this.createDefaultCachePolicy();
        JNDIBasedSecurityManagement.setSecurityDomainCache(am, cache);
        if (SecurityConfiguration.isDeepCopySubjectMode()) {
            JNDIBasedSecurityManagement.setDeepCopySubjectMode(am);
        }
        SecurityDomainContext securityDomainContext = new SecurityDomainContext(am, cache);
        securityDomainContext.setAuthorizationManager(this.createAuthorizationManager(securityDomain));
        securityDomainContext.setAuditMgr(this.createAuditManager(securityDomain));
        securityDomainContext.setIdentityTrustMgr(this.createIdentityTrustManager(securityDomain));
        securityDomainContext.setMappingMgr(this.createMappingManager(securityDomain));
        return securityDomainContext;
    }

    @ManagementOperation(description="Register the specified security domain", params={@ManagementParameter(name="domain", description="The security domain being registered")})
    public void registerJaasSecurityDomainInstance(JaasSecurityDomain domain) throws Exception {
        String domainName = domain.getSecurityDomain();
        SecurityDomainContext sdc = securityMgrMap.get(domainName);
        if (sdc != null) {
            sdc.setAuthenticationManager((AuthenticationManager)domain);
        } else {
            sdc = this.createSecurityDomainContext(domainName);
            sdc.setAuthenticationManager((AuthenticationManager)domain);
        }
        securityMgrMap.put(domainName, sdc);
    }

    @ManagementOperation(description="Deregister the specified security domain", params={@ManagementParameter(name="securityDomain", description="The name of the security domain being deregistered")})
    public void deregisterJaasSecurityDomainInstance(String securityDomain) {
        securityMgrMap.remove(securityDomain);
    }

    public static void clear() {
        RuntimePermission rtp = new RuntimePermission(JNDIBasedSecurityManagement.class.getName());
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(rtp);
        }
        securityMgrMap.clear();
    }

    private Object lookUpJNDI(String ctxName) {
        Object result = null;
        try {
            InitialContext ctx = new InitialContext();
            result = ctxName.startsWith(this.BASE_CTX) ? ctx.lookup(ctxName) : ctx.lookup(this.BASE_CTX + "/" + ctxName);
        }
        catch (Exception e) {
            log.trace((Object)("Look up of JNDI for " + ctxName + " failed with " + e.getLocalizedMessage()));
            return null;
        }
        return result;
    }

    private AuthenticationManager createAuthenticationManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.authenticationMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class, CallbackHandler.class);
        return (AuthenticationManager)ctr.newInstance(securityDomain, callBackHandler);
    }

    private AuthorizationManager createAuthorizationManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.authorizationMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (AuthorizationManager)ctr.newInstance(securityDomain);
    }

    private AuditManager createAuditManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.auditMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (AuditManager)ctr.newInstance(securityDomain);
    }

    private MappingManager createMappingManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.mappingMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (MappingManager)ctr.newInstance(securityDomain);
    }

    private IdentityTrustManager createIdentityTrustManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.identityTrustMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (IdentityTrustManager)ctr.newInstance(securityDomain);
    }

    private static void setSecurityDomainCache(AuthenticationManager securityMgr, CachePolicy cachePolicy) {
        block2: {
            try {
                Class[] setCachePolicyTypes = new Class[]{CachePolicy.class};
                Method m = securityMgr.getClass().getMethod("setCachePolicy", setCachePolicyTypes);
                Object[] setCachePolicyArgs = new Object[]{cachePolicy};
                m.invoke((Object)securityMgr, setCachePolicyArgs);
                log.debug((Object)("setCachePolicy, c=" + setCachePolicyArgs[0]));
            }
            catch (Exception e2) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)("Optional setCachePolicy failed" + e2.getLocalizedMessage()));
            }
        }
    }

    private static void setDeepCopySubjectMode(AuthenticationManager securityMgr) {
        block2: {
            try {
                Class[] argsType = new Class[]{Boolean.class};
                Method m = securityMgr.getClass().getMethod("setDeepCopySubjectOption", argsType);
                Object[] deepCopyArgs = new Object[]{Boolean.TRUE};
                m.invoke((Object)securityMgr, deepCopyArgs);
                log.trace((Object)("setDeepCopySubjectOption, option=" + deepCopyArgs[0]));
            }
            catch (Exception e2) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)("Optional setDeepCopySubjectMode failed" + e2.getLocalizedMessage()));
            }
        }
    }

    private CachePolicy createDefaultCachePolicy() {
        AuthenticationTimedCachePolicy cachePolicy = new AuthenticationTimedCachePolicy(SecurityConstantsBridge.defaultCacheTimeout, true, SecurityConstantsBridge.defaultCacheResolution);
        cachePolicy.create();
        cachePolicy.start();
        return cachePolicy;
    }

    private void initialize() {
        if (this.authMgrMap == null) {
            this.authMgrMap = new ConcurrentHashMap();
        }
        if (this.authzMgrMap == null) {
            this.authzMgrMap = new ConcurrentHashMap();
        }
        if (this.mappingMgrMap == null) {
            this.mappingMgrMap = new ConcurrentHashMap();
        }
        if (this.auditMgrMap == null) {
            this.auditMgrMap = new ConcurrentHashMap();
        }
        if (this.idmMgrMap == null) {
            this.idmMgrMap = new ConcurrentHashMap();
        }
    }

    private void initializeCallbackHandler() {
        String cbh = SecurityActions.getSystemProperty(CBH, null);
        if (cbh != null) {
            try {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                Class<?> clazz = tcl.loadClass(cbh);
                callBackHandler = (CallbackHandler)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing JNDIBasedSecurityManagement:", e);
            }
        }
        if (callBackHandler == null) {
            callBackHandler = new JBossCallbackHandler();
        }
    }

    public void start() {
        if (SecurityConstantsBridge.defaultCacheFlushPeriod > 0 && authCacheFlushThread == null) {
            authCacheFlushThread = new AuthenticationCacheFlushThread(securityMgrMap);
            authCacheFlushThread.start();
        }
    }

    public void stop() {
        if (authCacheFlushThread != null) {
            authCacheFlushThread.interrupt();
            authCacheFlushThread = null;
        }
    }
}

