/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.EntityPersistenceStore;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.metadata.EntityMetaData;
import org.jboss.system.ServiceMBeanSupport;

public class CMPInMemoryPersistenceManager
extends ServiceMBeanSupport
implements EntityPersistenceStore {
    protected EntityContainer con;
    protected HashMap beans;
    protected Field idField;
    protected Method isModified;

    public void setContainer(Container con) {
        this.con = (EntityContainer)con;
    }

    protected void createService() throws Exception {
        this.beans = new HashMap(1000);
        String ejbName = this.con.getBeanMetaData().getEjbName();
        this.idField = this.con.getBeanClass().getField("id");
        this.log.debug((Object)("Using id field: " + this.idField));
        try {
            this.isModified = this.con.getBeanClass().getMethod("isModified", new Class[0]);
            if (!this.isModified.getReturnType().equals(Boolean.TYPE)) {
                this.isModified = null;
                this.log.warn((Object)"Found isModified method, but return type is not boolean; ignoring");
            } else {
                this.log.debug((Object)("Using isModified method: " + this.isModified));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void stopService() throws Exception {
        this.beans.clear();
    }

    public Object createBeanClassInstance() throws Exception {
        return this.con.getBeanClass().newInstance();
    }

    public void initEntity(EntityEnterpriseContext ctx) {
        Object instance = ctx.getInstance();
        Class<?> ejbClass = instance.getClass();
        EntityMetaData metaData = (EntityMetaData)this.con.getBeanMetaData();
        Iterator i = metaData.getCMPFields();
        while (i.hasNext()) {
            try {
                Field cmpField = ejbClass.getField((String)i.next());
                Class<?> cmpFieldType = cmpField.getType();
                if (cmpFieldType.equals(Boolean.TYPE)) {
                    cmpField.setBoolean(instance, false);
                    continue;
                }
                if (cmpFieldType.equals(Byte.TYPE)) {
                    cmpField.setByte(instance, (byte)0);
                    continue;
                }
                if (cmpFieldType.equals(Integer.TYPE)) {
                    cmpField.setInt(instance, 0);
                    continue;
                }
                if (cmpFieldType.equals(Long.TYPE)) {
                    cmpField.setLong(instance, 0L);
                    continue;
                }
                if (cmpFieldType.equals(Short.TYPE)) {
                    cmpField.setShort(instance, (short)0);
                    continue;
                }
                if (cmpFieldType.equals(Character.TYPE)) {
                    cmpField.setChar(instance, '\u0000');
                    continue;
                }
                if (cmpFieldType.equals(Double.TYPE)) {
                    cmpField.setDouble(instance, 0.0);
                    continue;
                }
                if (cmpFieldType.equals(Float.TYPE)) {
                    cmpField.setFloat(instance, 0.0f);
                    continue;
                }
                cmpField.set(instance, null);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
    }

    public Object createEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        try {
            Object id = this.idField.get(ctx.getInstance());
            if (this.beans.containsKey(id)) {
                throw new DuplicateKeyException("Already exists: " + id);
            }
            this.storeEntity(id, ctx.getInstance());
            return id;
        }
        catch (IllegalAccessException e) {
            throw new CreateException("Could not create entity: " + e);
        }
    }

    public Object postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        return null;
    }

    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory) throws Exception {
        if (finderMethod.getName().equals("findByPrimaryKey")) {
            if (!this.beans.containsKey(args[0])) {
                throw new FinderException(args[0] + " does not exist");
            }
            return factory.getEntityEJBObject(args[0]);
        }
        return null;
    }

    public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory) throws Exception {
        if (finderMethod.getName().equals("findAll")) {
            return GenericEntityObjectFactory.UTIL.getEntityCollection(factory, this.beans.keySet());
        }
        return Collections.EMPTY_LIST;
    }

    public void activateEntity(EntityEnterpriseContext instance) {
    }

    public void loadEntity(EntityEnterpriseContext ctx) {
        try {
            CMPObjectInputStream in = new CMPObjectInputStream(new ByteArrayInputStream((byte[])this.beans.get(ctx.getId())));
            Object obj = ctx.getInstance();
            Field[] f = obj.getClass().getFields();
            for (int i = 0; i < f.length; ++i) {
                f[i].set(obj, in.readObject());
            }
            in.close();
        }
        catch (Exception e) {
            throw new EJBException("Load failed", e);
        }
    }

    public boolean isStoreRequired(EntityEnterpriseContext ctx) throws Exception {
        if (this.isModified == null) {
            return true;
        }
        Boolean modified = (Boolean)this.isModified.invoke(ctx.getInstance(), new Object[0]);
        return modified;
    }

    public boolean isModified(EntityEnterpriseContext ctx) throws Exception {
        return this.isStoreRequired(ctx);
    }

    public void storeEntity(EntityEnterpriseContext ctx) {
        this.storeEntity(ctx.getId(), ctx.getInstance());
    }

    public void passivateEntity(EntityEnterpriseContext instance) {
    }

    public void removeEntity(EntityEnterpriseContext ctx) throws RemoveException {
        if (this.beans.remove(ctx.getId()) == null) {
            throw new RemoveException("Could not remove bean:" + ctx.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeEntity(Object id, Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CMPObjectOutputStream out = new CMPObjectOutputStream(baos);
            try {
                Field[] f = obj.getClass().getFields();
                for (int i = 0; i < f.length; ++i) {
                    out.writeObject(f[i].get(obj));
                }
            }
            finally {
                out.close();
            }
            this.beans.put(id, baos.toByteArray());
        }
        catch (Exception e) {
            throw new EJBException("Store failed", e);
        }
    }

    static class CMPObjectInputStream
    extends ObjectInputStream {
        public CMPObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof Handle) {
                return ((Handle)obj).getEJBObject();
            }
            return obj;
        }
    }

    static class CMPObjectOutputStream
    extends ObjectOutputStream {
        public CMPObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof EJBObject) {
                return ((EJBObject)obj).getHandle();
            }
            return obj;
        }
    }
}

