/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management.recording;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.wsf.framework.management.recording.AbstractRecordProcessor;
import org.jboss.wsf.spi.management.recording.Record;

public class LogRecorder
extends AbstractRecordProcessor
implements Serializable {
    private static final long serialVersionUID = -7126227194320867819L;
    private Logger log = Logger.getLogger(this.getClass());

    public LogRecorder() {
        this.name = "LogRecorder";
    }

    @Override
    public void processRecord(Record record) {
        StringBuffer sb = new StringBuffer();
        if (this.isProcessMessageType()) {
            if (record.getMessageType() == Record.MessageType.INBOUND) {
                sb.append("INBOUND MESSAGE ");
                if (this.isProcessSourceHost() && record.getSourceHost() != null) {
                    sb.append("from ");
                    sb.append(record.getSourceHost());
                }
            } else if (record.getMessageType() == Record.MessageType.OUTBOUND) {
                sb.append("OUTBOUND MESSAGE ");
                if (this.isProcessDestinationHost() && record.getDestinationHost() != null) {
                    sb.append("to ");
                    sb.append(record.getDestinationHost());
                }
            } else {
                this.log.warn((Object)("Unknown message type: " + record.getMessageType()));
                if (this.isProcessSourceHost() && record.getSourceHost() != null) {
                    sb.append("from ");
                    sb.append(record.getSourceHost());
                }
                if (this.isProcessDestinationHost() && record.getDestinationHost() != null) {
                    sb.append("to ");
                    sb.append(record.getDestinationHost());
                }
            }
        } else {
            sb.append("MESSAGE");
        }
        sb.append(":");
        if (this.isProcessDate()) {
            sb.append("\nDate: ");
            sb.append(record.getDate());
        }
        sb.append("\nGroupID: ");
        sb.append(record.getGroupID());
        if (this.isProcessOperation()) {
            sb.append("\nOperation: ");
            sb.append(record.getOperation());
        }
        sb.append("\n");
        Map headers = record.getHeaders();
        if (this.isProcessHeaders() && headers != null) {
            for (String key : headers.keySet()) {
                sb.append(key);
                sb.append(": ");
                for (String h : (List)headers.get(key)) {
                    sb.append(h);
                    sb.append("; ");
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
        sb.append("\n");
        if (this.isProcessEnvelope()) {
            sb.append(record.getEnvelope());
        }
        this.log.debug((Object)sb.toString());
    }
}

