/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Hashtable;
import javax.ejb.TimerService;
import org.jboss.aop.Domain;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.ejb3.timerservice.spi.TimerServiceFactory_2;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public abstract class TimerServiceContainer
extends EJBContainer {
    private static Logger logger = Logger.getLogger(TimerServiceContainer.class);
    protected TimerService timerService;
    private TimerServiceFactory timerServiceFactory;

    protected TimerServiceContainer(String name, Domain domain, ClassLoader cl, String beanClassName, String ejbName, Hashtable ctxProperties, Ejb3Deployment deployment, JBossEnterpriseBeanMetaData beanMetaData) throws ClassNotFoundException {
        super(name, domain, cl, beanClassName, ejbName, ctxProperties, deployment, beanMetaData);
    }

    @Override
    protected void lockedStart() throws Exception {
        try {
            super.lockedStart();
            if (!this.isStatefulBean()) {
                this.timerService = this.createTimerService();
            }
        }
        catch (Exception e) {
            try {
                this.lockedStop();
            }
            catch (Exception ignore) {
                logger.debug((Object)"Failed to cleanup after start() failure", (Throwable)ignore);
            }
            throw e;
        }
    }

    @Override
    protected void afterStart() {
        super.afterStart();
        if (!this.isStatefulBean()) {
            this.restoreTimerService();
        }
    }

    @Override
    protected void lockedStop() throws Exception {
        if (this.timerService != null) {
            this.timerServiceFactory.suspendTimerService(this.timerService);
            this.timerService = null;
        }
        super.lockedStop();
    }

    @Override
    public TimerService getTimerService() {
        if (this.isStatefulBean()) {
            throw new UnsupportedOperationException("stateful bean doesn't support TimerService (EJB3 18.2#2)");
        }
        return this.timerService;
    }

    @Override
    public TimerService getTimerService(Object pKey) {
        return this.getTimerService();
    }

    @Inject
    public void setTimerServiceFactory(TimerServiceFactory factory) {
        this.timerServiceFactory = factory;
    }

    protected abstract TimedObjectInvoker getTimedObjectInvoker();

    private boolean isStatefulBean() {
        JBossEnterpriseBeanMetaData enterpriseBeanMetaData = this.xml;
        if (!enterpriseBeanMetaData.isSession()) {
            return false;
        }
        JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)enterpriseBeanMetaData;
        return sessionBean.isStateful();
    }

    private TimerService createTimerService() {
        TimedObjectInvoker timedObjectInvoker = this.getTimedObjectInvoker();
        if (timedObjectInvoker == null) {
            throw new IllegalStateException("Cannot create timerservice for EJB " + this.getEjbName() + " since there's no TimedObjectInvoker");
        }
        return this.timerServiceFactory.createTimerService(timedObjectInvoker);
    }

    private void restoreTimerService() {
        if (this.timerServiceFactory instanceof TimerServiceFactory_2) {
            ((TimerServiceFactory_2)this.timerServiceFactory).restoreTimerService(this.timerService, this.classloader);
        } else {
            logger.warn((Object)"EJBHREE-2193: using deprecated TimerServiceFactory for restoring timers");
            this.timerServiceFactory.restoreTimerService(this.timerService);
        }
    }
}

