/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.collection.CachedListImpl;
import org.jboss.cache.pojo.collection.CollectionInterceptorUtil;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;

public class CachedListInterceptor
extends AbstractCollectionInterceptor {
    private static final Map managedMethods_ = CollectionInterceptorUtil.getManagedMethods(List.class);
    private Map methodMap_;
    private List cacheImpl_;
    private List inMemImpl_;
    private List current_;

    public CachedListInterceptor(PojoCacheImpl cache, Fqn fqn, Class clazz, List obj) {
        super(cache, fqn);
        this.methodMap_ = CollectionInterceptorUtil.getMethodMap(clazz);
        this.cacheImpl_ = new CachedListImpl(cache, this);
        this.inMemImpl_ = obj;
        this.current_ = this.cacheImpl_;
    }

    private CachedListInterceptor(PojoCacheImpl cache, Fqn fqn) {
        super(cache, fqn);
    }

    public Object clone() {
        CachedListInterceptor interceptor = new CachedListInterceptor(this.cache, this.fqn);
        interceptor.setFqn(this.getFqn());
        interceptor.setAopInstance(this.getAopInstance());
        interceptor.setCurrentCopy(this.getCurrentCopy());
        interceptor.setInMemoryCopy(this.getInMemoryCopy());
        interceptor.setCacheCopy(this.getCacheCopy());
        return interceptor;
    }

    public void setInterceptor(Interceptor intcptr) {
        CachedListInterceptor interceptor = (CachedListInterceptor)intcptr;
        this.setFqn(interceptor.getFqn());
        this.setAopInstance(interceptor.getAopInstance());
        this.setCurrentCopy(interceptor.getCurrentCopy());
        this.setInMemoryCopy(interceptor.getInMemoryCopy());
        this.setCacheCopy(interceptor.getCacheCopy());
    }

    public void attach(Fqn fqn, boolean copyToCache) {
        super.attach(fqn, copyToCache);
        if (copyToCache) {
            this.toCache();
        }
        this.current_ = this.cacheImpl_;
    }

    private void toCache() {
        if (this.inMemImpl_ == null) {
            throw new IllegalStateException("CachedListInterceptor.toCache(). inMemImpl is null.");
        }
        ArrayList tmpList = new ArrayList();
        for (int i = this.inMemImpl_.size(); i > 0; --i) {
            Object obj = this.inMemImpl_.remove(i - 1);
            tmpList.add(obj);
        }
        int size = tmpList.size();
        for (int i = 0; i < tmpList.size(); ++i) {
            this.cacheImpl_.add(tmpList.get(size - i - 1));
        }
        this.inMemImpl_ = null;
    }

    public void detach(boolean removeFromCache) {
        super.detach(removeFromCache);
        this.toMemory(removeFromCache);
        this.current_ = this.inMemImpl_;
    }

    public Object getCurrentCopy() {
        return this.current_;
    }

    void setInMemoryCopy(Object obj) {
        this.inMemImpl_ = (List)obj;
    }

    Object getInMemoryCopy() {
        return this.inMemImpl_;
    }

    Object getCacheCopy() {
        return this.cacheImpl_;
    }

    void setCacheCopy(Object obj) {
        this.cacheImpl_ = (List)obj;
    }

    void setCurrentCopy(Object obj) {
        this.current_ = (List)obj;
    }

    private void toMemory(boolean removeFromCache) {
        if (this.inMemImpl_ == null) {
            this.inMemImpl_ = new ArrayList();
        }
        ArrayList tmpList = new ArrayList();
        for (int i = this.cacheImpl_.size(); i > 0; --i) {
            int j = i - 1;
            Object obj = null;
            obj = removeFromCache ? (Object)this.cacheImpl_.remove(j) : (Object)this.cacheImpl_.get(j);
            tmpList.add(obj);
        }
        int size = tmpList.size();
        this.inMemImpl_.clear();
        for (int i = 0; i < tmpList.size(); ++i) {
            this.inMemImpl_.add(tmpList.get(size - i - 1));
        }
    }

    public Object getSerializationCopy() {
        List list;
        if (this.current_ == this.inMemImpl_) {
            return this.inMemImpl_;
        }
        List mem = this.inMemImpl_;
        if (mem == null) {
            list = new ArrayList();
        } else {
            list = (List)this.copyOrConstruct(mem);
            if (list == null) {
                throw new PojoCacheException("Could not serialize class, since it can not be copied: " + mem.getClass().getName());
            }
        }
        list.clear();
        int size = this.cacheImpl_.size();
        for (int i = 0; i < size; ++i) {
            list.add(this.cacheImpl_.get(i));
        }
        return list;
    }

    public String getName() {
        return "CachedListInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.current_ == null) {
            throw new IllegalStateException("CachedListInterceptor.invoke(). current_ is null.");
        }
        return CollectionInterceptorUtil.invoke(invocation, this, this.current_, this.methodMap_, managedMethods_);
    }
}

