/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.security.permission.Identifier;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.security.permission.IdentifierStrategy;
import org.jboss.seam.util.Strings;

public class EntityIdentifierStrategy
implements IdentifierStrategy {
    private Expressions.ValueExpression<EntityManager> entityManager;
    private PersistenceProvider persistenceProvider;
    private Map<Class, String> identifierNames = new ConcurrentHashMap<Class, String>();

    public EntityIdentifierStrategy() {
        this.persistenceProvider = (PersistenceProvider)Component.getInstance(PersistenceProvider.class, true);
        if (this.entityManager == null) {
            this.entityManager = Expressions.instance().createValueExpression("#{entityManager}", EntityManager.class);
        }
    }

    public boolean canIdentify(Class targetClass) {
        return targetClass.isAnnotationPresent(Entity.class);
    }

    public String getIdentifier(Object target) {
        Object persProviderId = this.persistenceProvider.getId(target, this.lookupEntityManager());
        return String.format("%s:%s", this.getIdentifierName(target.getClass()), persProviderId);
    }

    private String getIdentifierName(Class cls) {
        if (!this.identifierNames.containsKey(cls)) {
            Identifier identifier;
            String name = null;
            if (cls.isAnnotationPresent(Identifier.class) && !Strings.isEmpty((identifier = cls.getAnnotation(Identifier.class)).name())) {
                name = identifier.name();
            }
            if (name == null) {
                name = Seam.getComponentName(cls);
            }
            if (name == null) {
                name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
            }
            this.identifierNames.put(cls, name);
            return name;
        }
        return this.identifierNames.get(cls);
    }

    private EntityManager lookupEntityManager() {
        return this.entityManager.getValue();
    }
}

