/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jboss.crypto.CryptoUtil;
import org.jboss.logging.Logger;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPPermission;

public class SRPServerSession
implements Serializable {
    static final long serialVersionUID = -2448005747721323704L;
    private static int B_LEN = 64;
    private static Logger log = Logger.getLogger(SRPServerSession.class);
    private SRPParameters params;
    private BigInteger N;
    private BigInteger g;
    private BigInteger v;
    private BigInteger b;
    private BigInteger B;
    private byte[] K;
    private transient MessageDigest clientHash;
    private byte[] M1;
    private transient MessageDigest serverHash;
    private byte[] M2;

    public SRPServerSession(String username, byte[] vb, SRPParameters params) {
        MessageDigest tmp;
        this.params = params;
        this.v = new BigInteger(1, vb);
        this.g = new BigInteger(1, params.g);
        this.N = new BigInteger(1, params.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("g: " + CryptoUtil.tob64((byte[])params.g)));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("v: " + CryptoUtil.tob64((byte[])vb)));
        }
        this.serverHash = CryptoUtil.newDigest();
        this.clientHash = CryptoUtil.newDigest();
        byte[] hn = CryptoUtil.newDigest().digest(params.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(N): " + CryptoUtil.tob64((byte[])hn)));
        }
        byte[] hg = CryptoUtil.newDigest().digest(params.g);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(g): " + CryptoUtil.tob64((byte[])hg)));
        }
        byte[] hxg = CryptoUtil.xor((byte[])hn, (byte[])hg, (int)20);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(N) xor H(g): " + CryptoUtil.tob64((byte[])hxg)));
        }
        this.clientHash.update(hxg);
        if (log.isTraceEnabled()) {
            tmp = CryptoUtil.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g)]: " + CryptoUtil.tob64((byte[])tmp.digest())));
        }
        this.clientHash.update(CryptoUtil.newDigest().digest(username.getBytes()));
        if (log.isTraceEnabled()) {
            tmp = CryptoUtil.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U)]: " + CryptoUtil.tob64((byte[])tmp.digest())));
        }
        this.clientHash.update(params.s);
        if (log.isTraceEnabled()) {
            tmp = CryptoUtil.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s]: " + CryptoUtil.tob64((byte[])tmp.digest())));
        }
        this.K = null;
    }

    public SRPParameters getParameters() {
        return this.params;
    }

    public byte[] exponential() {
        if (this.B == null) {
            BigInteger one = BigInteger.valueOf(1L);
            do {
                this.b = new BigInteger(B_LEN, CryptoUtil.getPRNG());
            } while (this.b.compareTo(one) <= 0);
            this.B = this.v.add(this.g.modPow(this.b, this.N));
            if (this.B.compareTo(this.N) >= 0) {
                this.B = this.B.subtract(this.N);
            }
        }
        return CryptoUtil.trim((byte[])this.B.toByteArray());
    }

    public void buildSessionKey(byte[] ab) throws NoSuchAlgorithmException {
        MessageDigest tmp;
        if (log.isTraceEnabled()) {
            log.trace((Object)("A: " + CryptoUtil.tob64((byte[])ab)));
        }
        byte[] nb = CryptoUtil.trim((byte[])this.B.toByteArray());
        this.clientHash.update(ab);
        if (log.isTraceEnabled()) {
            tmp = CryptoUtil.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s | A]: " + CryptoUtil.tob64((byte[])tmp.digest())));
        }
        this.clientHash.update(nb);
        if (log.isTraceEnabled()) {
            tmp = CryptoUtil.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s | A | B]: " + CryptoUtil.tob64((byte[])tmp.digest())));
        }
        this.serverHash.update(ab);
        byte[] hB = CryptoUtil.newDigest().digest(nb);
        byte[] ub = new byte[]{hB[0], hB[1], hB[2], hB[3]};
        BigInteger A = new BigInteger(1, ab);
        if (log.isTraceEnabled()) {
            log.trace((Object)("A: " + CryptoUtil.tob64((byte[])A.toByteArray())));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("B: " + CryptoUtil.tob64((byte[])this.B.toByteArray())));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("v: " + CryptoUtil.tob64((byte[])this.v.toByteArray())));
        }
        BigInteger u = new BigInteger(1, ub);
        if (log.isTraceEnabled()) {
            log.trace((Object)("u: " + CryptoUtil.tob64((byte[])u.toByteArray())));
        }
        BigInteger A_v2u = A.multiply(this.v.modPow(u, this.N)).mod(this.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("A * v^u: " + CryptoUtil.tob64((byte[])A_v2u.toByteArray())));
        }
        BigInteger S = A_v2u.modPow(this.b, this.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("S: " + CryptoUtil.tob64((byte[])S.toByteArray())));
        }
        MessageDigest sessionDigest = MessageDigest.getInstance(this.params.hashAlgorithm);
        this.K = sessionDigest.digest(S.toByteArray());
        if (log.isTraceEnabled()) {
            log.trace((Object)("K: " + CryptoUtil.tob64((byte[])this.K)));
        }
        this.clientHash.update(this.K);
        if (log.isTraceEnabled()) {
            MessageDigest tmp2 = CryptoUtil.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s | A | B | K]: " + CryptoUtil.tob64((byte[])tmp2.digest())));
        }
    }

    public byte[] getSessionKey() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SRPPermission p = new SRPPermission("getSessionKey");
            sm.checkPermission(p);
        }
        return this.K;
    }

    public byte[] getServerResponse() {
        if (this.M2 == null) {
            this.M2 = this.serverHash.digest();
        }
        return this.M2;
    }

    public byte[] getClientResponse() {
        return this.M1;
    }

    public boolean verify(byte[] clientM1) {
        boolean valid = false;
        this.M1 = this.clientHash.digest();
        if (log.isTraceEnabled()) {
            log.trace((Object)("verify M1: " + CryptoUtil.tob64((byte[])this.M1)));
            log.trace((Object)("verify clientM1: " + CryptoUtil.tob64((byte[])clientM1)));
        }
        if (Arrays.equals(clientM1, this.M1)) {
            this.serverHash.update(this.M1);
            this.serverHash.update(this.K);
            if (log.isTraceEnabled()) {
                MessageDigest tmp = CryptoUtil.copy((MessageDigest)this.serverHash);
                log.trace((Object)("H(A | M1 | K)" + CryptoUtil.tob64((byte[])tmp.digest())));
            }
            valid = true;
        }
        return valid;
    }
}

