/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.ext;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.ext.JoeSNMPTrapSender;
import org.apache.log4j.ext.SnmpDelimitedConversionPatternLayout;
import org.apache.log4j.ext.SnmpTrapSenderFacade;
import org.apache.log4j.ext.SysUpTimeResolver;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class SNMPTrapAppender
extends AppenderSkeleton {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final SysUpTimeResolver DEFAULT_SYSUP_TIME_RESOLVER = new SysUpTimeResolver(){
        private final long appenderLoadedTime = System.currentTimeMillis();

        @Override
        public long getSysUpTime() {
            return System.currentTimeMillis() - this.appenderLoadedTime;
        }
    };
    private String managementHost = "127.0.0.1";
    private int managementHostTrapListenPort = 162;
    private String enterpriseOID = "1.3.6.1.2.1.2.0";
    private String localIPAddress = "127.0.0.1";
    private int localTrapSendPort = 161;
    private int genericTrapType = 6;
    private int specificTrapType = 1;
    private String applicationTrapOID = "1.3.6.1.2.1.2.0.0.0.0";
    private String communityString = "public";
    private long sysUpTime = 0L;
    private String implementationClassName;
    private SysUpTimeResolver sysUpTimeResolver = DEFAULT_SYSUP_TIME_RESOLVER;
    private String forwardStackTraceWithTrap = "false";

    public SNMPTrapAppender() {
    }

    public SNMPTrapAppender(Layout layoutValue) {
        this.layout = layoutValue;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        if (!this.isAsSevereAsThreshold((Priority)event.getLevel())) {
            return;
        }
        if (null == this.getLayout()) {
            this.errorHandler.error("No layout set for the Appender named [" + this.getName() + "]", null, 5);
            return;
        }
        SnmpTrapSenderFacade out = this.loadImplementationClass();
        if (0L == this.sysUpTime) {
            this.sysUpTime = this.sysUpTimeResolver.getSysUpTime();
        }
        out.initialize(this.managementHost, this.managementHostTrapListenPort, this.enterpriseOID, this.localIPAddress, this.localTrapSendPort, this.genericTrapType, this.specificTrapType, this.communityString, this.sysUpTime);
        this.parseLoggingEventAndAddToTrap(event, out);
        out.sendTrap();
    }

    private SnmpTrapSenderFacade loadImplementationClass() {
        try {
            return (SnmpTrapSenderFacade)OptionConverter.instantiateByClassName((String)this.implementationClassName, Class.forName(this.implementationClassName), (Object)new JoeSNMPTrapSender());
        }
        catch (ClassNotFoundException ex) {
            this.errorHandler.error("Could not locate the implementation class - " + this.implementationClassName, (Exception)ex, 0);
            return null;
        }
    }

    private void parseLoggingEventAndAddToTrap(LoggingEvent event, SnmpTrapSenderFacade out) {
        PatternLayout pl = (PatternLayout)this.getLayout();
        if (pl instanceof SnmpDelimitedConversionPatternLayout) {
            ((SnmpDelimitedConversionPatternLayout)pl).formatMultipleVarBinds(event, out);
        } else {
            out.addTrapMessageVariable(this.applicationTrapOID, this.getLayout().format(event));
        }
        this.handleThrowable(event, out);
    }

    private void handleThrowable(LoggingEvent event, SnmpTrapSenderFacade out) {
        String[] stackTrace;
        if (this.getLayout().ignoresThrowable() && TRUE.equals(this.getForwardStackTraceWithTrap()) && null != (stackTrace = event.getThrowableStrRep())) {
            for (int i = 0; i < stackTrace.length; ++i) {
                out.addTrapMessageVariable(this.applicationTrapOID, stackTrace[i]);
            }
        }
    }

    private static boolean testStringForBooleanEquivalency(String value) {
        return TRUE.equalsIgnoreCase(value) || FALSE.equalsIgnoreCase(value);
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    public String getManagementHost() {
        return this.managementHost;
    }

    public void setManagementHost(String managementHostValue) {
        this.managementHost = managementHostValue;
    }

    public int getManagementHostTrapListenPort() {
        return this.managementHostTrapListenPort;
    }

    public void setManagementHostTrapListenPort(int managementHostTrapListenPortValue) {
        this.managementHostTrapListenPort = managementHostTrapListenPortValue;
    }

    public String getEnterpriseOID() {
        return this.enterpriseOID;
    }

    public void setEnterpriseOID(String enterpriseOIDValue) {
        this.enterpriseOID = enterpriseOIDValue;
    }

    public String getLocalIPAddress() {
        return this.localIPAddress;
    }

    public void setLocalIPAddress(String localIPAddressValue) {
        this.localIPAddress = localIPAddressValue;
    }

    public int getGenericTrapType() {
        return this.genericTrapType;
    }

    public void setGenericTrapType(int genericTrapTypeValue) {
        this.genericTrapType = genericTrapTypeValue;
    }

    public int getSpecificTrapType() {
        return this.specificTrapType;
    }

    public void setSpecificTrapType(int specificTrapTypeValue) {
        this.specificTrapType = specificTrapTypeValue;
    }

    public String getApplicationTrapOID() {
        return this.applicationTrapOID;
    }

    public void setApplicationTrapOID(String applicationTrapOIDValue) {
        this.applicationTrapOID = applicationTrapOIDValue;
    }

    public String getCommunityString() {
        return this.communityString;
    }

    public void setCommunityString(String communityStringValue) {
        this.communityString = communityStringValue;
    }

    public long getSysUpTime() {
        return this.sysUpTime;
    }

    public void setSysUpTime(long sysUpTimeValue) {
        this.sysUpTime = sysUpTimeValue;
    }

    public int getLocalTrapSendPort() {
        return this.localTrapSendPort;
    }

    public void setLocalTrapSendPort(int localTrapSendPortValue) {
        this.localTrapSendPort = localTrapSendPortValue;
    }

    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    public void setImplementationClassName(String implementationClassNameValue) {
        this.implementationClassName = implementationClassNameValue;
    }

    public SysUpTimeResolver getSysUpTimeResolver() {
        return this.sysUpTimeResolver;
    }

    public void setSysUpTimeResolver(String value) {
        this.sysUpTimeResolver = (SysUpTimeResolver)OptionConverter.instantiateByClassName((String)value, SysUpTimeResolver.class, (Object)DEFAULT_SYSUP_TIME_RESOLVER);
    }

    public String getForwardStackTraceWithTrap() {
        return this.forwardStackTraceWithTrap;
    }

    public void setForwardStackTraceWithTrap(String forwardStackTraceWithTrap) {
        if (!SNMPTrapAppender.testStringForBooleanEquivalency(forwardStackTraceWithTrap)) {
            throw new IllegalArgumentException("Value of forwardStackTraceWithTrap must be set toTRUE or FALSE! Illegal value was:" + forwardStackTraceWithTrap);
        }
        this.forwardStackTraceWithTrap = forwardStackTraceWithTrap;
    }
}

