/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.config;

import com.sun.faces.config.ConfigureListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jboss.logging.Logger;

public class JBossJSFConfigureListener
extends ConfigureListener {
    private static final String WAR_BUNDLES_JSF_IMPL = "org.jboss.jbossfaces.WAR_BUNDLES_JSF_IMPL";
    private static Logger LOG = Logger.getLogger(JBossJSFConfigureListener.class);
    private ServletContext servletContext;
    private boolean initialized = false;

    public static boolean warBundlesJSFImpl(ServletContext servletContext) {
        String bundledJSFImpl = servletContext.getInitParameter(WAR_BUNDLES_JSF_IMPL);
        return bundledJSFImpl != null && bundledJSFImpl.equalsIgnoreCase("true");
    }

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        if (JBossJSFConfigureListener.warBundlesJSFImpl(this.servletContext)) {
            return;
        }
        this.checkForMyFaces();
        JBossJSFConfigureListener.initializeJspRuntime();
        this.initialized = true;
        super.contextInitialized(event);
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.initialized) {
            this.initialized = false;
            super.contextDestroyed(event);
        }
    }

    private static void initializeJspRuntime() {
        try {
            Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void checkForMyFaces() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.apache.myfaces.webapp.StartupServletContextListener");
            LOG.warn((Object)"MyFaces JSF implementation found!  This version of JBoss AS ships with the java.net implementation of JSF.  There are known issues when mixing JSF implementations.  This warning does not apply to MyFaces component libraries such as Tomahawk.  However, myfaces-impl.jar and myfaces-api.jar should not be used without disabling the built-in JSF implementation.  See the JBoss wiki for more details.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

