/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.system.server.profileservice.repository.clustered.metadata.AbstractSortedMetadataContainer;
import org.jboss.system.server.profileservice.repository.clustered.metadata.Identifiable;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="repositoryRootType", propOrder={"content", "name"})
public class RepositoryRootMetadata
extends AbstractSortedMetadataContainer<List<String>, RepositoryItemMetadata>
implements Identifiable<String>,
Serializable,
Comparable<RepositoryRootMetadata> {
    private static final long serialVersionUID = -4102001386900647551L;
    private String name;

    public RepositoryRootMetadata() {
    }

    public RepositoryRootMetadata(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.setName(name);
    }

    public RepositoryRootMetadata(RepositoryRootMetadata toCopy) {
        this(toCopy.getName());
        Collection<RepositoryItemMetadata> content = toCopy.getContent();
        Collection internal = this.getExposedCollection();
        for (RepositoryItemMetadata item : content) {
            internal.add(new RepositoryItemMetadata(item));
        }
    }

    @Override
    public String getId() {
        return this.name;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="content")
    public Collection<RepositoryItemMetadata> getContent() {
        return this.getExposedCollection();
    }

    public void setContent(Collection<RepositoryItemMetadata> content) {
        Collection internal = this.getExposedCollection();
        internal.clear();
        if (content != null) {
            for (RepositoryItemMetadata md : content) {
                internal.add(md);
            }
        }
    }

    public RepositoryItemMetadata getItemMetadata(List<String> path) {
        return (RepositoryItemMetadata)this.getContainedMetadata(path);
    }

    @Deprecated
    public void addItemMetadata(RepositoryItemMetadata md) {
        this.getExposedCollection().add(md);
    }

    @Deprecated
    public boolean removeItemMetadata(List<String> path) {
        RepositoryItemMetadata md = this.getItemMetadata(path);
        if (md != null) {
            return this.getExposedCollection().remove(md);
        }
        return false;
    }

    @Override
    public int compareTo(RepositoryRootMetadata other) {
        int result = 0;
        if (this.name == null) {
            if (other.name != null) {
                result = 1;
            }
        } else {
            result = other.name == null ? -1 : this.name.compareTo(other.name);
        }
        if (result == 0) {
            ArrayList us = new ArrayList(this.getExposedCollection());
            ArrayList them = new ArrayList(other.getExposedCollection());
            result = them.size() - us.size();
            if (result == 0) {
                for (int i = 0; i < us.size() && (result = ((RepositoryItemMetadata)us.get(i)).compareTo((RepositoryItemMetadata)them.get(i))) == 0; ++i) {
                }
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RepositoryRootMetadata) {
            RepositoryRootMetadata other = (RepositoryRootMetadata)obj;
            return ((Object)this.getExposedCollection()).equals(other.getExposedCollection()) && this.name != null && this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + ((Object)this.getExposedCollection()).hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[name='" + this.name + ']';
    }
}

