/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Random;
import javax.faces.context.FacesContext;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.faces.Selector;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.JpaTokenStore;
import org.jboss.seam.security.RunAsOperation;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.security.TokenStore;
import org.jboss.seam.security.management.IdentityManager;
import org.jboss.seam.util.Base64;

@Name(value="org.jboss.seam.security.rememberMe")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
public class RememberMe
implements Serializable {
    private UsernameSelector usernameSelector;
    private TokenSelector tokenSelector;
    private TokenStore tokenStore;
    private boolean enabled;
    private int cookieMaxAge = 31536000;
    private boolean autoLoggedIn;
    private Random random = new Random(System.currentTimeMillis());
    private Mode mode = Mode.usernameOnly;

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (this.usernameSelector != null && this.mode.equals((Object)Mode.usernameOnly)) {
                this.usernameSelector.setCookieEnabled(enabled);
                this.usernameSelector.setDirty();
            } else if (this.tokenSelector != null && this.mode.equals((Object)Mode.autoLogin)) {
                this.tokenSelector.setCookieEnabled(enabled);
                this.tokenSelector.setDirty();
            }
        }
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    @Create
    public void create() {
        if (this.mode.equals((Object)Mode.usernameOnly)) {
            this.usernameSelector = new UsernameSelector();
            this.usernameSelector.setCookieEnabled(this.enabled);
        } else if (this.mode.equals((Object)Mode.autoLogin)) {
            this.tokenSelector = new TokenSelector();
            this.tokenSelector.setCookieEnabled(this.enabled);
            if (this.tokenStore == null) {
                this.tokenStore = (TokenStore)Component.getInstance(JpaTokenStore.class, true);
            }
        }
    }

    protected String generateTokenValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(new UID().toString());
        sb.append(":");
        sb.append(this.random.nextLong());
        return sb.toString();
    }

    protected String encodeToken(String username, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(username);
        sb.append(":");
        sb.append(value);
        return Base64.encodeBytes(sb.toString().getBytes());
    }

    public String getCookiePath() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return ctx != null ? ctx.getExternalContext().getRequestContextPath() : null;
    }

    @Observer(value={"org.jboss.seam.security.initCredentials"})
    public void initCredentials(Credentials credentials) {
        String cookiePath = this.getCookiePath();
        if (this.mode.equals((Object)Mode.usernameOnly)) {
            String username;
            if (cookiePath != null) {
                this.usernameSelector.setCookiePath(cookiePath);
            }
            if ((username = this.usernameSelector.getCookieValue()) != null) {
                this.setEnabled(true);
                credentials.setUsername(username);
            }
            this.usernameSelector.setDirty();
        } else if (this.mode.equals((Object)Mode.autoLogin)) {
            String token;
            if (cookiePath != null) {
                this.tokenSelector.setCookiePath(cookiePath);
            }
            if ((token = this.tokenSelector.getCookieValue()) != null) {
                this.setEnabled(true);
                DecodedToken decoded = new DecodedToken(token);
                if (this.tokenStore.validateToken(decoded.getUsername(), decoded.getValue())) {
                    credentials.setUsername(decoded.getUsername());
                    credentials.setPassword(decoded.getValue());
                } else {
                    this.tokenStore.invalidateAll(decoded.getUsername());
                }
            }
        }
    }

    @Observer(value={"org.jboss.seam.security.quietLogin"})
    public void quietLogin() {
        Identity identity = Identity.instance();
        if (this.mode.equals((Object)Mode.autoLogin) && this.isEnabled()) {
            final String username = identity.getCredentials().getUsername();
            final BoolWrapper userEnabled = new BoolWrapper();
            final ArrayList roles = new ArrayList();
            if (this.tokenStore.validateToken(username, identity.getCredentials().getPassword())) {
                new RunAsOperation(true){

                    public void execute() {
                        if (IdentityManager.instance().isUserEnabled(username)) {
                            userEnabled.value = true;
                            for (String role : IdentityManager.instance().getImpliedRoles(username)) {
                                roles.add(role);
                            }
                        }
                    }
                }.run();
                if (userEnabled.value) {
                    identity.unAuthenticate();
                    identity.preAuthenticate();
                    for (String role : roles) {
                        identity.addRole(role);
                    }
                    identity.getSubject().getPrincipals().add(new SimplePrincipal(username));
                    identity.postAuthenticate();
                    this.autoLoggedIn = true;
                }
            }
        }
    }

    @Observer(value={"org.jboss.seam.security.loggedOut"})
    public void loggedOut() {
        if (this.mode.equals((Object)Mode.autoLogin)) {
            this.tokenSelector.clearCookieValue();
        }
    }

    @Observer(value={"org.jboss.seam.security.postAuthenticate"})
    public void postAuthenticate(Identity identity) {
        if (this.mode.equals((Object)Mode.usernameOnly)) {
            this.usernameSelector.setDirty();
            if (!this.enabled) {
                this.usernameSelector.clearCookieValue();
            } else {
                this.usernameSelector.setCookieMaxAge(this.cookieMaxAge);
                this.usernameSelector.setCookieValueIfEnabled(Identity.instance().getCredentials().getUsername());
            }
        } else if (this.mode.equals((Object)Mode.autoLogin)) {
            this.tokenSelector.setDirty();
            DecodedToken decoded = new DecodedToken(this.tokenSelector.getCookieValue());
            if (decoded.getUsername() != null) {
                this.tokenStore.invalidateToken(decoded.getUsername(), decoded.getValue());
            }
            if (!this.enabled) {
                this.tokenSelector.clearCookieValue();
            } else {
                String value = this.generateTokenValue();
                this.tokenStore.createToken(identity.getPrincipal().getName(), value);
                this.tokenSelector.setCookieEnabled(this.enabled);
                this.tokenSelector.setCookieMaxAge(this.cookieMaxAge);
                this.tokenSelector.setCookieValueIfEnabled(this.encodeToken(identity.getPrincipal().getName(), value));
            }
        }
    }

    @Observer(value={"org.jboss.seam.security.credentialsUpdated"})
    public void credentialsUpdated() {
        if (this.mode.equals((Object)Mode.usernameOnly)) {
            this.usernameSelector.setDirty();
        }
    }

    public boolean isAutoLoggedIn() {
        return this.autoLoggedIn;
    }

    private class BoolWrapper {
        boolean value;

        private BoolWrapper() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        disabled,
        usernameOnly,
        autoLogin;

    }

    private class DecodedToken {
        private String username;
        private String value;

        public DecodedToken(String cookieValue) {
            if (cookieValue != null) {
                try {
                    String decoded = new String(Base64.decode(cookieValue));
                    this.username = decoded.substring(0, decoded.indexOf(58));
                    this.value = decoded.substring(decoded.indexOf(58) + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public String getUsername() {
            return this.username;
        }

        public String getValue() {
            return this.value;
        }
    }

    class TokenSelector
    extends UsernameSelector {
        TokenSelector() {
        }

        public String getCookieName() {
            return "org.jboss.seam.security.authtoken";
        }
    }

    class UsernameSelector
    extends Selector {
        UsernameSelector() {
        }

        public String getCookieName() {
            return "org.jboss.seam.security.username";
        }

        public void setDirty() {
            super.setDirty();
        }

        public String getCookieValue() {
            return super.getCookieValue();
        }

        public void clearCookieValue() {
            super.clearCookieValue();
        }

        public void setCookieValueIfEnabled(String value) {
            super.setCookieValueIfEnabled(value);
        }
    }
}

