/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.persistent;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.web.tomcat.service.session.persistent.RDBMSStoreBase;

public class DataSourcePersistentStore
extends RDBMSStoreBase {
    private static final String info = "DataSourceStore/1.0";
    private static final String storeName = "DataSourceStore";
    private String jndiName;
    private DataSource injecteddatasource;
    private DataSource datasource;

    public DataSourcePersistentStore() {
    }

    public DataSourcePersistentStore(DataSource datasource) {
        this.injecteddatasource = datasource;
    }

    public String getDataSourceJndiName() {
        return this.jndiName;
    }

    public void setDataSourceJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getStoreName() {
        return storeName;
    }

    protected Connection getConnection() throws SQLException {
        try {
            Connection conn = null;
            conn = this.getConnectionName() != null ? this.datasource.getConnection(this.getConnectionName(), this.getConnectionPassword()) : this.datasource.getConnection();
            conn.setAutoCommit(false);
            return conn;
        }
        catch (SQLException e) {
            try {
                this.findDataSource();
            }
            catch (Exception e1) {
                this.getLogger().error((Object)"Caught exception reacquiring datasource", (Throwable)e1);
            }
            throw e;
        }
    }

    public String getInfo() {
        return info;
    }

    protected void releaseConnection(Connection conn) {
        this.cleanup(conn, null, false);
    }

    protected void startStore() {
        this.findDataSource();
    }

    private void findDataSource() {
        if (this.injecteddatasource == null) {
            if (this.jndiName == null) {
                throw new IllegalStateException("No jndiName has been configured");
            }
            try {
                this.datasource = (DataSource)new InitialContext().lookup(this.jndiName);
                this.getLogger().debug((Object)("DataSource found at " + this.jndiName));
            }
            catch (NamingException e) {
                throw new IllegalStateException("Caught NamingException looking up DataSource at " + this.jndiName + " -- " + e.getLocalizedMessage());
            }
        } else {
            this.datasource = this.injecteddatasource;
        }
    }
}

