/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.cache.Region;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.util.ArrayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsImpl
implements Statistics,
StatisticsImplementor {
    private static final Logger log = LoggerFactory.getLogger(StatisticsImpl.class);
    private SessionFactoryImplementor sessionFactory;
    private boolean isStatisticsEnabled;
    private long startTime;
    private long sessionOpenCount;
    private long sessionCloseCount;
    private long flushCount;
    private long connectCount;
    private long prepareStatementCount;
    private long closeStatementCount;
    private long entityLoadCount;
    private long entityUpdateCount;
    private long entityInsertCount;
    private long entityDeleteCount;
    private long entityFetchCount;
    private long collectionLoadCount;
    private long collectionUpdateCount;
    private long collectionRemoveCount;
    private long collectionRecreateCount;
    private long collectionFetchCount;
    private long secondLevelCacheHitCount;
    private long secondLevelCacheMissCount;
    private long secondLevelCachePutCount;
    private long queryExecutionCount;
    private long queryExecutionMaxTime;
    private String queryExecutionMaxTimeQueryString;
    private long queryCacheHitCount;
    private long queryCacheMissCount;
    private long queryCachePutCount;
    private long commitedTransactionCount;
    private long transactionCount;
    private long optimisticFailureCount;
    private final Map secondLevelCacheStatistics = new HashMap();
    private final Map entityStatistics = new HashMap();
    private final Map collectionStatistics = new HashMap();
    private final Map queryStatistics = new HashMap();

    public StatisticsImpl() {
        this.clear();
    }

    public StatisticsImpl(SessionFactoryImplementor sessionFactory) {
        this.clear();
        this.sessionFactory = sessionFactory;
    }

    @Override
    public synchronized void clear() {
        this.secondLevelCacheHitCount = 0L;
        this.secondLevelCacheMissCount = 0L;
        this.secondLevelCachePutCount = 0L;
        this.sessionCloseCount = 0L;
        this.sessionOpenCount = 0L;
        this.flushCount = 0L;
        this.connectCount = 0L;
        this.prepareStatementCount = 0L;
        this.closeStatementCount = 0L;
        this.entityDeleteCount = 0L;
        this.entityInsertCount = 0L;
        this.entityUpdateCount = 0L;
        this.entityLoadCount = 0L;
        this.entityFetchCount = 0L;
        this.collectionRemoveCount = 0L;
        this.collectionUpdateCount = 0L;
        this.collectionRecreateCount = 0L;
        this.collectionLoadCount = 0L;
        this.collectionFetchCount = 0L;
        this.queryExecutionCount = 0L;
        this.queryCacheHitCount = 0L;
        this.queryExecutionMaxTime = 0L;
        this.queryExecutionMaxTimeQueryString = null;
        this.queryCacheMissCount = 0L;
        this.queryCachePutCount = 0L;
        this.transactionCount = 0L;
        this.commitedTransactionCount = 0L;
        this.optimisticFailureCount = 0L;
        this.secondLevelCacheStatistics.clear();
        this.entityStatistics.clear();
        this.collectionStatistics.clear();
        this.queryStatistics.clear();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void openSession() {
        ++this.sessionOpenCount;
    }

    @Override
    public synchronized void closeSession() {
        ++this.sessionCloseCount;
    }

    @Override
    public synchronized void flush() {
        ++this.flushCount;
    }

    @Override
    public synchronized void connect() {
        ++this.connectCount;
    }

    @Override
    public synchronized void loadEntity(String entityName) {
        ++this.entityLoadCount;
        ++this.getEntityStatistics((String)entityName).loadCount;
    }

    @Override
    public synchronized void fetchEntity(String entityName) {
        ++this.entityFetchCount;
        ++this.getEntityStatistics((String)entityName).fetchCount;
    }

    @Override
    public synchronized EntityStatistics getEntityStatistics(String entityName) {
        EntityStatistics es = (EntityStatistics)this.entityStatistics.get(entityName);
        if (es == null) {
            es = new EntityStatistics(entityName);
            this.entityStatistics.put(entityName, es);
        }
        return es;
    }

    @Override
    public synchronized void updateEntity(String entityName) {
        ++this.entityUpdateCount;
        EntityStatistics es = this.getEntityStatistics(entityName);
        ++es.updateCount;
    }

    @Override
    public synchronized void insertEntity(String entityName) {
        ++this.entityInsertCount;
        EntityStatistics es = this.getEntityStatistics(entityName);
        ++es.insertCount;
    }

    @Override
    public synchronized void deleteEntity(String entityName) {
        ++this.entityDeleteCount;
        EntityStatistics es = this.getEntityStatistics(entityName);
        ++es.deleteCount;
    }

    @Override
    public synchronized CollectionStatistics getCollectionStatistics(String role) {
        CollectionStatistics cs = (CollectionStatistics)this.collectionStatistics.get(role);
        if (cs == null) {
            cs = new CollectionStatistics(role);
            this.collectionStatistics.put(role, cs);
        }
        return cs;
    }

    @Override
    public synchronized void loadCollection(String role) {
        ++this.collectionLoadCount;
        ++this.getCollectionStatistics((String)role).loadCount;
    }

    @Override
    public synchronized void fetchCollection(String role) {
        ++this.collectionFetchCount;
        ++this.getCollectionStatistics((String)role).fetchCount;
    }

    @Override
    public synchronized void updateCollection(String role) {
        ++this.collectionUpdateCount;
        ++this.getCollectionStatistics((String)role).updateCount;
    }

    @Override
    public synchronized void recreateCollection(String role) {
        ++this.collectionRecreateCount;
        ++this.getCollectionStatistics((String)role).recreateCount;
    }

    @Override
    public synchronized void removeCollection(String role) {
        ++this.collectionRemoveCount;
        ++this.getCollectionStatistics((String)role).removeCount;
    }

    @Override
    public synchronized SecondLevelCacheStatistics getSecondLevelCacheStatistics(String regionName) {
        SecondLevelCacheStatistics slcs = (SecondLevelCacheStatistics)this.secondLevelCacheStatistics.get(regionName);
        if (slcs == null) {
            if (this.sessionFactory == null) {
                return null;
            }
            Region region = this.sessionFactory.getSecondLevelCacheRegion(regionName);
            if (region == null) {
                return null;
            }
            slcs = new SecondLevelCacheStatistics(region);
            this.secondLevelCacheStatistics.put(regionName, slcs);
        }
        return slcs;
    }

    @Override
    public synchronized void secondLevelCachePut(String regionName) {
        ++this.secondLevelCachePutCount;
        ++this.getSecondLevelCacheStatistics((String)regionName).putCount;
    }

    @Override
    public synchronized void secondLevelCacheHit(String regionName) {
        ++this.secondLevelCacheHitCount;
        ++this.getSecondLevelCacheStatistics((String)regionName).hitCount;
    }

    @Override
    public synchronized void secondLevelCacheMiss(String regionName) {
        ++this.secondLevelCacheMissCount;
        ++this.getSecondLevelCacheStatistics((String)regionName).missCount;
    }

    @Override
    public synchronized void queryExecuted(String hql, int rows, long time) {
        ++this.queryExecutionCount;
        if (this.queryExecutionMaxTime < time) {
            this.queryExecutionMaxTime = time;
            this.queryExecutionMaxTimeQueryString = hql;
        }
        if (hql != null) {
            QueryStatistics qs = this.getQueryStatistics(hql);
            qs.executed(rows, time);
        }
    }

    @Override
    public synchronized void queryCacheHit(String hql, String regionName) {
        ++this.queryCacheHitCount;
        if (hql != null) {
            QueryStatistics qs = this.getQueryStatistics(hql);
            ++qs.cacheHitCount;
        }
        SecondLevelCacheStatistics slcs = this.getSecondLevelCacheStatistics(regionName);
        ++slcs.hitCount;
    }

    @Override
    public synchronized void queryCacheMiss(String hql, String regionName) {
        ++this.queryCacheMissCount;
        if (hql != null) {
            QueryStatistics qs = this.getQueryStatistics(hql);
            ++qs.cacheMissCount;
        }
        SecondLevelCacheStatistics slcs = this.getSecondLevelCacheStatistics(regionName);
        ++slcs.missCount;
    }

    @Override
    public synchronized void queryCachePut(String hql, String regionName) {
        ++this.queryCachePutCount;
        if (hql != null) {
            QueryStatistics qs = this.getQueryStatistics(hql);
            ++qs.cachePutCount;
        }
        SecondLevelCacheStatistics slcs = this.getSecondLevelCacheStatistics(regionName);
        ++slcs.putCount;
    }

    @Override
    public synchronized QueryStatistics getQueryStatistics(String queryString) {
        QueryStatistics qs = (QueryStatistics)this.queryStatistics.get(queryString);
        if (qs == null) {
            qs = new QueryStatistics(queryString);
            this.queryStatistics.put(queryString, qs);
        }
        return qs;
    }

    @Override
    public long getEntityDeleteCount() {
        return this.entityDeleteCount;
    }

    @Override
    public long getEntityInsertCount() {
        return this.entityInsertCount;
    }

    @Override
    public long getEntityLoadCount() {
        return this.entityLoadCount;
    }

    @Override
    public long getEntityFetchCount() {
        return this.entityFetchCount;
    }

    @Override
    public long getEntityUpdateCount() {
        return this.entityUpdateCount;
    }

    @Override
    public long getQueryExecutionCount() {
        return this.queryExecutionCount;
    }

    @Override
    public long getQueryCacheHitCount() {
        return this.queryCacheHitCount;
    }

    @Override
    public long getQueryCacheMissCount() {
        return this.queryCacheMissCount;
    }

    @Override
    public long getQueryCachePutCount() {
        return this.queryCachePutCount;
    }

    @Override
    public long getFlushCount() {
        return this.flushCount;
    }

    @Override
    public long getConnectCount() {
        return this.connectCount;
    }

    @Override
    public long getSecondLevelCacheHitCount() {
        return this.secondLevelCacheHitCount;
    }

    @Override
    public long getSecondLevelCacheMissCount() {
        return this.secondLevelCacheMissCount;
    }

    @Override
    public long getSecondLevelCachePutCount() {
        return this.secondLevelCachePutCount;
    }

    @Override
    public long getSessionCloseCount() {
        return this.sessionCloseCount;
    }

    @Override
    public long getSessionOpenCount() {
        return this.sessionOpenCount;
    }

    @Override
    public long getCollectionLoadCount() {
        return this.collectionLoadCount;
    }

    @Override
    public long getCollectionFetchCount() {
        return this.collectionFetchCount;
    }

    @Override
    public long getCollectionUpdateCount() {
        return this.collectionUpdateCount;
    }

    @Override
    public long getCollectionRemoveCount() {
        return this.collectionRemoveCount;
    }

    @Override
    public long getCollectionRecreateCount() {
        return this.collectionRecreateCount;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void logSummary() {
        log.info("Logging statistics....");
        log.info("start time: " + this.startTime);
        log.info("sessions opened: " + this.sessionOpenCount);
        log.info("sessions closed: " + this.sessionCloseCount);
        log.info("transactions: " + this.transactionCount);
        log.info("successful transactions: " + this.commitedTransactionCount);
        log.info("optimistic lock failures: " + this.optimisticFailureCount);
        log.info("flushes: " + this.flushCount);
        log.info("connections obtained: " + this.connectCount);
        log.info("statements prepared: " + this.prepareStatementCount);
        log.info("statements closed: " + this.closeStatementCount);
        log.info("second level cache puts: " + this.secondLevelCachePutCount);
        log.info("second level cache hits: " + this.secondLevelCacheHitCount);
        log.info("second level cache misses: " + this.secondLevelCacheMissCount);
        log.info("entities loaded: " + this.entityLoadCount);
        log.info("entities updated: " + this.entityUpdateCount);
        log.info("entities inserted: " + this.entityInsertCount);
        log.info("entities deleted: " + this.entityDeleteCount);
        log.info("entities fetched (minimize this): " + this.entityFetchCount);
        log.info("collections loaded: " + this.collectionLoadCount);
        log.info("collections updated: " + this.collectionUpdateCount);
        log.info("collections removed: " + this.collectionRemoveCount);
        log.info("collections recreated: " + this.collectionRecreateCount);
        log.info("collections fetched (minimize this): " + this.collectionFetchCount);
        log.info("queries executed to database: " + this.queryExecutionCount);
        log.info("query cache puts: " + this.queryCachePutCount);
        log.info("query cache hits: " + this.queryCacheHitCount);
        log.info("query cache misses: " + this.queryCacheMissCount);
        log.info("max query time: " + this.queryExecutionMaxTime + "ms");
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean b) {
        this.isStatisticsEnabled = b;
    }

    @Override
    public long getQueryExecutionMaxTime() {
        return this.queryExecutionMaxTime;
    }

    @Override
    public String[] getQueries() {
        return ArrayHelper.toStringArray(this.queryStatistics.keySet());
    }

    @Override
    public String[] getEntityNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.entityStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllClassMetadata().keySet());
    }

    @Override
    public String[] getCollectionRoleNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.collectionStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllCollectionMetadata().keySet());
    }

    @Override
    public String[] getSecondLevelCacheRegionNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.secondLevelCacheStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllSecondLevelCacheRegions().keySet());
    }

    @Override
    public void endTransaction(boolean success) {
        ++this.transactionCount;
        if (success) {
            ++this.commitedTransactionCount;
        }
    }

    @Override
    public long getSuccessfulTransactionCount() {
        return this.commitedTransactionCount;
    }

    @Override
    public long getTransactionCount() {
        return this.transactionCount;
    }

    @Override
    public void closeStatement() {
        ++this.closeStatementCount;
    }

    @Override
    public void prepareStatement() {
        ++this.prepareStatementCount;
    }

    @Override
    public long getCloseStatementCount() {
        return this.closeStatementCount;
    }

    @Override
    public long getPrepareStatementCount() {
        return this.prepareStatementCount;
    }

    @Override
    public void optimisticFailure(String entityName) {
        ++this.optimisticFailureCount;
        ++this.getEntityStatistics((String)entityName).optimisticFailureCount;
    }

    @Override
    public long getOptimisticFailureCount() {
        return this.optimisticFailureCount;
    }

    public String toString() {
        return new StringBuffer().append("Statistics[").append("start time=").append(this.startTime).append(",sessions opened=").append(this.sessionOpenCount).append(",sessions closed=").append(this.sessionCloseCount).append(",transactions=").append(this.transactionCount).append(",successful transactions=").append(this.commitedTransactionCount).append(",optimistic lock failures=").append(this.optimisticFailureCount).append(",flushes=").append(this.flushCount).append(",connections obtained=").append(this.connectCount).append(",statements prepared=").append(this.prepareStatementCount).append(",statements closed=").append(this.closeStatementCount).append(",second level cache puts=").append(this.secondLevelCachePutCount).append(",second level cache hits=").append(this.secondLevelCacheHitCount).append(",second level cache misses=").append(this.secondLevelCacheMissCount).append(",entities loaded=").append(this.entityLoadCount).append(",entities updated=").append(this.entityUpdateCount).append(",entities inserted=").append(this.entityInsertCount).append(",entities deleted=").append(this.entityDeleteCount).append(",entities fetched=").append(this.entityFetchCount).append(",collections loaded=").append(this.collectionLoadCount).append(",collections updated=").append(this.collectionUpdateCount).append(",collections removed=").append(this.collectionRemoveCount).append(",collections recreated=").append(this.collectionRecreateCount).append(",collections fetched=").append(this.collectionFetchCount).append(",queries executed to database=").append(this.queryExecutionCount).append(",query cache puts=").append(this.queryCachePutCount).append(",query cache hits=").append(this.queryCacheHitCount).append(",query cache misses=").append(this.queryCacheMissCount).append(",max query time=").append(this.queryExecutionMaxTime).append(']').toString();
    }

    @Override
    public String getQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }
}

