/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.jboss.jmx.connector.invoker.RolesAuthorization;
import org.jboss.jmx.connector.invoker.SecurityActions;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.server.Invocation;

public class AuthorizationInterceptor
extends AbstractInterceptor {
    private Object authenticator = null;
    private Method authorize;

    public AuthorizationInterceptor() {
        try {
            this.setAuthorizingClass(RolesAuthorization.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAuthorizingClass(Class clazz) throws Exception {
        this.authenticator = clazz.newInstance();
        this.log.debug((Object)("Loaded authenticator: " + this.authenticator));
        Class[] sig = new Class[]{Principal.class, Subject.class, String.class, String.class};
        this.authorize = clazz.getMethod("authorize", sig);
        this.log.debug((Object)"Found authorize(Principal, Subject, String, String)");
    }

    public Object invoke(Invocation invocation) throws Throwable {
        String opName;
        String type = invocation.getType();
        if (type == "invoke" && (opName = invocation.getName()).equals("invoke")) {
            Object[] args = invocation.getArgs();
            org.jboss.invocation.Invocation inv = (org.jboss.invocation.Invocation)args[0];
            Principal caller = inv.getPrincipal();
            Object[] obj = inv.getArguments();
            if (obj != null && obj.length > 1) {
                ObjectName objname = (ObjectName)obj[0];
                if (obj[1] instanceof String) {
                    String opname = (String)obj[1];
                    try {
                        this.checkAuthorization(caller, objname.getCanonicalName(), opname);
                    }
                    catch (SecurityException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        String msg = "Failed to authorize principal=" + caller + ",MBean=" + objname + ", Operation=" + opname;
                        SecurityException ex = new SecurityException(msg);
                        ex.initCause(e);
                        throw ex;
                    }
                }
            }
        }
        AbstractInterceptor i = invocation.nextInterceptor();
        return i.invoke(invocation);
    }

    private void checkAuthorization(Principal caller, String objname, String opname) throws Exception {
        Subject subject = SecurityActions.getActiveSubject();
        if (subject == null) {
            throw new SecurityException("No active Subject found, add th AuthenticationInterceptor");
        }
        try {
            Object[] args = new Object[]{caller, subject, objname, opname};
            this.authorize.invoke(this.authenticator, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t);
        }
    }
}

