/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.Map;
import org.hibernate.loader.EntityAliases;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.util.CollectionHelper;

public class DefaultEntityAliases
implements EntityAliases {
    private final String[] suffixedKeyColumns;
    private final String[] suffixedVersionColumn;
    private final String[][] suffixedPropertyColumns;
    private final String suffixedDiscriminatorColumn;
    private final String suffix;
    private final String rowIdAlias;
    private final Map userProvidedAliases;

    public DefaultEntityAliases(Loadable persister, String suffix) {
        this(CollectionHelper.EMPTY_MAP, persister, suffix);
    }

    public DefaultEntityAliases(Map userProvidedAliases, Loadable persister, String suffix) {
        this.suffix = suffix;
        this.userProvidedAliases = userProvidedAliases;
        String[] keyColumnsCandidates = this.getUserProvidedAliases(persister.getIdentifierPropertyName(), null);
        this.suffixedKeyColumns = keyColumnsCandidates == null ? this.getUserProvidedAliases("id", this.getIdentifierAliases(persister, suffix)) : keyColumnsCandidates;
        DefaultEntityAliases.intern(this.suffixedKeyColumns);
        this.suffixedPropertyColumns = this.getSuffixedPropertyAliases(persister);
        this.suffixedDiscriminatorColumn = this.getUserProvidedAlias("class", this.getDiscriminatorAlias(persister, suffix));
        this.suffixedVersionColumn = persister.isVersioned() ? this.suffixedPropertyColumns[persister.getVersionProperty()] : null;
        this.rowIdAlias = "rowid_" + suffix;
    }

    protected String getDiscriminatorAlias(Loadable persister, String suffix) {
        return persister.getDiscriminatorAlias(suffix);
    }

    protected String[] getIdentifierAliases(Loadable persister, String suffix) {
        return persister.getIdentifierAliases(suffix);
    }

    protected String[] getPropertyAliases(Loadable persister, int j) {
        return persister.getPropertyAliases(this.suffix, j);
    }

    private String[] getUserProvidedAliases(String propertyPath, String[] defaultAliases) {
        String[] result = (String[])this.userProvidedAliases.get(propertyPath);
        if (result == null) {
            return defaultAliases;
        }
        return result;
    }

    private String getUserProvidedAlias(String propertyPath, String defaultAlias) {
        String[] columns = (String[])this.userProvidedAliases.get(propertyPath);
        if (columns == null) {
            return defaultAlias;
        }
        return columns[0];
    }

    @Override
    public String[][] getSuffixedPropertyAliases(Loadable persister) {
        int size = persister.getPropertyNames().length;
        String[][] suffixedPropertyAliases = new String[size][];
        for (int j = 0; j < size; ++j) {
            suffixedPropertyAliases[j] = this.getUserProvidedAliases(persister.getPropertyNames()[j], this.getPropertyAliases(persister, j));
            DefaultEntityAliases.intern(suffixedPropertyAliases[j]);
        }
        return suffixedPropertyAliases;
    }

    @Override
    public String[] getSuffixedVersionAliases() {
        return this.suffixedVersionColumn;
    }

    @Override
    public String[][] getSuffixedPropertyAliases() {
        return this.suffixedPropertyColumns;
    }

    @Override
    public String getSuffixedDiscriminatorAlias() {
        return this.suffixedDiscriminatorColumn;
    }

    @Override
    public String[] getSuffixedKeyAliases() {
        return this.suffixedKeyColumns;
    }

    @Override
    public String getRowIdAlias() {
        return this.rowIdAlias;
    }

    private static void intern(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].intern();
        }
    }
}

