/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.plugins.AbstractPropertyInfo;
import org.jboss.beans.info.plugins.BeanInfoUtil;
import org.jboss.beans.info.plugins.NestedPropertyInfo;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.beans.info.spi.EventInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.joinpoint.spi.ConstructorJoinpoint;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanInfo
extends JBossObject
implements BeanInfo {
    private String name;
    protected ClassAdapter classAdapter;
    private Set<PropertyInfo> properties = CollectionsFactory.createLazySet();
    private transient Map<String, PropertyInfo> propertiesByName = CollectionsFactory.createLazyMap();
    private Set<ConstructorInfo> constructors;
    private Set<MethodInfo> methods;
    private Set<EventInfo> events;
    private BeanInfoFactory beanInfoFactory;

    public AbstractBeanInfo(BeanInfoFactory beanInfoFactory, ClassAdapter classAdapter, Set<PropertyInfo> properties, Set<ConstructorInfo> constructors, Set<MethodInfo> methods, Set<EventInfo> events) {
        this.beanInfoFactory = beanInfoFactory;
        if (classAdapter == null) {
            throw new IllegalArgumentException("Null class adapter.");
        }
        this.name = classAdapter.getClassInfo().getName();
        this.classAdapter = classAdapter;
        this.setProperties(properties);
        this.constructors = constructors;
        this.methods = methods;
        this.events = events;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<PropertyInfo> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Set<PropertyInfo> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties = new HashSet<PropertyInfo>(properties.size());
            this.propertiesByName = new HashMap<String, PropertyInfo>(properties.size());
            for (PropertyInfo property : properties) {
                this.replaceAndAddProperty(property);
            }
        }
    }

    @Override
    public PropertyInfo getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        PropertyInfo property = this.findPropertyInfo(name);
        if (property == null) {
            throw new IllegalArgumentException("No such property " + name + " for bean " + this.getName() + " available " + this.propertiesByName.keySet());
        }
        return property;
    }

    protected PropertyInfo findPropertyInfo(String name) {
        return this.propertiesByName.get(name);
    }

    protected void replaceAndAddProperty(PropertyInfo property) {
        property = this.replaceProperty(property);
        this.addProperty(property);
    }

    protected void addProperty(PropertyInfo property) {
        this.properties.add(property);
        PropertyInfo previous = this.propertiesByName.put(property.getName(), property);
        if (previous != null) {
            NestedPropertyInfo nestedPropertyInfo;
            if (previous instanceof NestedPropertyInfo) {
                nestedPropertyInfo = (NestedPropertyInfo)previous;
            } else {
                nestedPropertyInfo = new NestedPropertyInfo(previous.getName(), previous.getUpperName(), this);
                nestedPropertyInfo.addPropertyInfo(previous);
                this.propertiesByName.put(previous.getName(), nestedPropertyInfo);
            }
            nestedPropertyInfo.addPropertyInfo(property);
        }
        if (property instanceof AbstractPropertyInfo) {
            AbstractPropertyInfo ainfo = (AbstractPropertyInfo)property;
            ainfo.setBeanInfo(this);
        }
    }

    protected PropertyInfo replaceProperty(PropertyInfo original) {
        return original;
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.classAdapter.getClassInfo();
    }

    @Override
    public JoinpointFactory getJoinpointFactory() {
        return this.classAdapter.getJoinpointFactory();
    }

    @Override
    public Set<ConstructorInfo> getConstructors() {
        return this.constructors;
    }

    @Override
    public void setConstructors(Set<ConstructorInfo> constructors) {
        this.constructors = constructors;
    }

    @Override
    public Set<EventInfo> getEvents() {
        return this.events;
    }

    @Override
    public void setEvents(Set<EventInfo> events) {
        this.events = events;
    }

    @Override
    public Set<MethodInfo> getMethods() {
        return this.methods;
    }

    @Override
    public void setMethods(Set<MethodInfo> methods) {
        this.methods = methods;
    }

    @Override
    public BeanInfoFactory getBeanInfoFactory() {
        return this.beanInfoFactory;
    }

    @Override
    public Object newInstance() throws Throwable {
        return this.newInstance((String[])null, null);
    }

    @Override
    public Object newInstance(String[] paramTypes, Object[] params) throws Throwable {
        ConstructorJoinpoint joinpoint = Config.getConstructorJoinpoint(this.getJoinpointFactory(), paramTypes, params);
        return joinpoint.dispatch();
    }

    @Override
    public Object newInstance(Class<?>[] paramTypes, Object[] params) throws Throwable {
        return this.newInstance(AbstractBeanInfo.classesToStrings(paramTypes), params);
    }

    @Override
    public Object newInstance(TypeInfo[] paramTypes, Object[] params) throws Throwable {
        return this.newInstance(AbstractBeanInfo.typeInfosToStrings(paramTypes), params);
    }

    @Override
    public Object getProperty(Object bean, String name) throws Throwable {
        return BeanInfoUtil.get(this, bean, name);
    }

    @Override
    public void setProperty(Object bean, String name, Object value) throws Throwable {
        BeanInfoUtil.set(this, bean, name, value);
    }

    @Override
    public Object invoke(Object bean, String name) throws Throwable {
        return this.invoke(bean, name, (String[])null, null);
    }

    @Override
    public Object invoke(Object bean, String name, String[] paramTypes, Object[] params) throws Throwable {
        MethodJoinpoint joinpoint = Config.getMethodJoinpoint(bean, this.getJoinpointFactory(), name, paramTypes, params);
        return joinpoint.dispatch();
    }

    @Override
    public Object invoke(Object bean, String name, Class<?>[] paramTypes, Object[] params) throws Throwable {
        return this.invoke(bean, name, AbstractBeanInfo.classesToStrings(paramTypes), params);
    }

    @Override
    public Object invoke(Object bean, String name, TypeInfo[] paramTypes, Object[] params) throws Throwable {
        return this.invoke(bean, name, AbstractBeanInfo.typeInfosToStrings(paramTypes), params);
    }

    @Override
    public Object invokeStatic(String name) throws Throwable {
        return this.invokeStatic(name, (String[])null, null);
    }

    @Override
    public Object invokeStatic(String name, String[] paramTypes, Object[] params) throws Throwable {
        MethodJoinpoint joinpoint = Config.getStaticMethodJoinpoint(this.getJoinpointFactory(), name, paramTypes, params);
        return joinpoint.dispatch();
    }

    @Override
    public Object invokeStatic(String name, Class<?>[] paramTypes, Object[] params) throws Throwable {
        return this.invokeStatic(name, AbstractBeanInfo.classesToStrings(paramTypes), params);
    }

    @Override
    public Object invokeStatic(String name, TypeInfo[] paramTypes, Object[] params) throws Throwable {
        return this.invokeStatic(name, AbstractBeanInfo.typeInfosToStrings(paramTypes), params);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractBeanInfo)) {
            return false;
        }
        AbstractBeanInfo other = (AbstractBeanInfo)object;
        if (AbstractBeanInfo.notEqual((Object)this.name, (Object)other.name)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.classAdapter, (Object)other.classAdapter)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.properties, other.properties)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.methods, other.methods)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.constructors, other.constructors)) {
            return false;
        }
        return !AbstractBeanInfo.notEqual(this.events, other.events);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" classInfo=");
        this.classAdapter.toShortString(buffer);
        buffer.append(" properties=");
        AbstractBeanInfo.list((JBossStringBuilder)buffer, this.properties);
        buffer.append(" methods=");
        AbstractBeanInfo.list((JBossStringBuilder)buffer, this.methods);
        buffer.append(" constructors=");
        AbstractBeanInfo.list((JBossStringBuilder)buffer, this.constructors);
        buffer.append(" events=");
        AbstractBeanInfo.list((JBossStringBuilder)buffer, this.events);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    public int getHashCode() {
        return this.name.hashCode();
    }

    private static String[] classesToStrings(Class<?>[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        String[] result = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] == null) {
                throw new IllegalArgumentException("Null class in parameter types: " + Arrays.asList(classes));
            }
            result[i] = classes[i].getName();
        }
        return result;
    }

    private static String[] typeInfosToStrings(TypeInfo[] typeInfos) {
        if (typeInfos == null || typeInfos.length == 0) {
            return null;
        }
        String[] result = new String[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            if (typeInfos[i] == null) {
                throw new IllegalArgumentException("Null class in parameter types: " + Arrays.asList(typeInfos));
            }
            result[i] = typeInfos[i].getName();
        }
        return result;
    }
}

