/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metadata.plugins.loader;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ejb3.metadata.ComponentMetaDataLoaderFactory;
import org.jboss.ejb3.metadata.MetaDataBridge;
import org.jboss.ejb3.metadata.plugins.loader.AbstractMetaDataLoader;
import org.jboss.ejb3.metadata.plugins.loader.AbstractMethodMetaDataLoader;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationItem;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.Signature;

public class BridgedMetaDataLoader<M>
extends AbstractMetaDataLoader {
    private static final Logger log = Logger.getLogger(BridgedMetaDataLoader.class);
    private List<ComponentMetaDataLoaderFactory<M>> factories = new ArrayList<ComponentMetaDataLoaderFactory<M>>();
    private List<MetaDataBridge<M>> bridges = new ArrayList<MetaDataBridge<M>>();
    private M metaData;
    private ClassLoader classLoader;

    public BridgedMetaDataLoader(ScopeKey key, M metaData, ClassLoader classLoader) {
        this(key, metaData, classLoader, null);
    }

    public BridgedMetaDataLoader(ScopeKey key, M metaData, ClassLoader classLoader, List<MetaDataBridge<M>> defaultBridges) {
        super(key);
        assert (classLoader != null) : "classLoader is null";
        this.metaData = metaData;
        this.classLoader = classLoader;
        if (defaultBridges != null) {
            this.bridges.addAll(defaultBridges);
        }
    }

    public boolean addComponentMetaDataLoaderFactory(ComponentMetaDataLoaderFactory<M> componentMetaDataLoaderFactory) {
        return this.factories.add(componentMetaDataLoaderFactory);
    }

    public boolean addMetaDataBridge(MetaDataBridge<M> bridge) {
        return this.bridges.add(bridge);
    }

    public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature) {
        if (this.metaData == null) {
            return null;
        }
        for (ComponentMetaDataLoaderFactory<M> factory : this.factories) {
            MetaDataRetrieval retrieval = factory.createComponentMetaDataRetrieval(this.metaData, signature, this.getScope(), this.classLoader);
            if (retrieval == null) continue;
            return retrieval;
        }
        if (signature instanceof DeclaredMethodSignature) {
            return new MethodMetaDataRetrieval((DeclaredMethodSignature)signature);
        }
        return super.getComponentMetaDataRetrieval(signature);
    }

    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        if (this.metaData == null) {
            return null;
        }
        for (MetaDataBridge<M> bridge : this.bridges) {
            T annotation = bridge.retrieveAnnotation(annotationType, this.metaData, this.classLoader);
            if (annotation == null) continue;
            return new SimpleAnnotationItem(annotation);
        }
        return null;
    }

    private class MethodMetaDataRetrieval
    extends AbstractMethodMetaDataLoader {
        private DeclaredMethodSignature signature;

        public MethodMetaDataRetrieval(DeclaredMethodSignature methodSignature) {
            this.signature = methodSignature;
        }

        public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
            if (BridgedMetaDataLoader.this.metaData == null) {
                return null;
            }
            for (MetaDataBridge bridge : BridgedMetaDataLoader.this.bridges) {
                T annotation = bridge.retrieveAnnotation(annotationType, BridgedMetaDataLoader.this.metaData, BridgedMetaDataLoader.this.classLoader, this.signature);
                if (annotation == null) continue;
                return new SimpleAnnotationItem(annotation);
            }
            return null;
        }
    }
}

