/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.util.TreeSet;

class SnmpTimer {
    private TimerLogic m_timerLogic = new TimerLogic();
    private Thread m_thread = new Thread((Runnable)this.m_timerLogic, "SnmpTimer");

    public SnmpTimer() {
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    public void schedule(Runnable runnable, long delay) {
        this.m_timerLogic.schedule(runnable, delay);
    }

    public void cancel(boolean waitForAll) {
        this.m_timerLogic.cancel(waitForAll);
    }

    private static class TimerLogic
    implements Runnable {
        private boolean m_isActive = true;
        private Thread m_thread;
        private TreeSet m_items = new TreeSet();

        private TimerLogic() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.m_thread = Thread.currentThread();
            while (this.m_isActive) {
                try {
                    TimerElement timerElement = null;
                    TreeSet treeSet = this.m_items;
                    synchronized (treeSet) {
                        while (this.m_items.isEmpty()) {
                            this.m_items.wait();
                        }
                        do {
                            long timeToWait;
                            if ((timeToWait = (timerElement = (TimerElement)this.m_items.first()).m_when - System.currentTimeMillis()) <= 0L) continue;
                            this.m_items.wait(timeToWait);
                        } while (this.m_items.first() != timerElement || timerElement.m_when - System.currentTimeMillis() > 0L);
                        this.m_items.remove(timerElement);
                    }
                    timerElement.m_runnable.run();
                }
                catch (InterruptedException ex) {
                }
                catch (Throwable throwable) {}
            }
        }

        public synchronized void cancel(boolean waitForAll) {
            if (this.m_isActive) {
                this.m_isActive = false;
                this.m_thread.interrupt();
            }
            if (waitForAll) {
                while (true) {
                    try {
                        this.m_thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void schedule(Runnable runnable, long delay) {
            if (!this.m_isActive) {
                throw new IllegalStateException("Timer is not active");
            }
            TimerElement timerElement = new TimerElement(runnable, delay);
            TreeSet treeSet = this.m_items;
            synchronized (treeSet) {
                this.m_items.add(timerElement);
                if (this.m_items.size() == 1 || this.m_items.first() == timerElement) {
                    this.m_items.notify();
                }
            }
        }
    }

    private static class TimerElement
    implements Comparable {
        private Runnable m_runnable;
        private long m_when;
        private long m_sequence;
        private static int ms_nextInSequence;

        TimerElement(Runnable runnable, long delay) {
            this.m_runnable = runnable;
            this.m_when = System.currentTimeMillis() + delay;
            this.m_sequence = TimerElement.getNextInSequence();
        }

        public String toString() {
            return "TimerElement[ID=" + this.m_sequence + ", When=" + this.m_when + ", Runnable=" + this.m_runnable + "]";
        }

        private static synchronized long getNextInSequence() {
            return ms_nextInSequence++;
        }

        public int compareTo(Object o) {
            TimerElement compareTo = (TimerElement)o;
            if (this.m_when < compareTo.m_when) {
                return -1;
            }
            if (this.m_when > compareTo.m_when) {
                return 1;
            }
            return this.m_sequence < compareTo.m_sequence ? -1 : (this.m_sequence == compareTo.m_sequence ? 0 : 1);
        }
    }
}

