/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authc;

import java.net.InetAddress;
import org.jsecurity.authc.InetAuthenticationToken;
import org.jsecurity.authc.RememberMeAuthenticationToken;

public class UsernamePasswordToken
implements InetAuthenticationToken,
RememberMeAuthenticationToken {
    private String username;
    private char[] password;
    private boolean rememberMe = false;
    private InetAddress inetAddress;

    public UsernamePasswordToken() {
    }

    public UsernamePasswordToken(String username, char[] password) {
        this(username, password, false, null);
    }

    public UsernamePasswordToken(String username, String password) {
        this(username, password != null ? password.toCharArray() : null, false, null);
    }

    public UsernamePasswordToken(String username, char[] password, InetAddress inetAddress) {
        this(username, password, false, inetAddress);
    }

    public UsernamePasswordToken(String username, String password, InetAddress inetAddress) {
        this(username, password != null ? password.toCharArray() : null, false, inetAddress);
    }

    public UsernamePasswordToken(String username, char[] password, boolean rememberMe) {
        this(username, password, rememberMe, null);
    }

    public UsernamePasswordToken(String username, String password, boolean rememberMe) {
        this(username, password != null ? password.toCharArray() : null, rememberMe, null);
    }

    public UsernamePasswordToken(String username, char[] password, boolean rememberMe, InetAddress inetAddress) {
        this.username = username;
        this.password = password;
        this.rememberMe = rememberMe;
        this.inetAddress = inetAddress;
    }

    public UsernamePasswordToken(String username, String password, boolean rememberMe, InetAddress inetAddress) {
        this(username, password != null ? password.toCharArray() : null, rememberMe, inetAddress);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public Object getPrincipal() {
        return this.getUsername();
    }

    public Object getCredentials() {
        return this.getPassword();
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public void clear() {
        this.username = null;
        this.inetAddress = null;
        this.rememberMe = false;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
            this.password = null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" - ");
        sb.append(this.username);
        sb.append(", rememberMe=").append(this.rememberMe);
        if (this.inetAddress != null) {
            sb.append(" (").append(this.inetAddress).append(")");
        }
        return sb.toString();
    }
}

