/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RuleDoclet;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import java.io.IOException;
import java.io.Writer;

public class WikiRuleDoclet
extends RuleDoclet {
    private int countRules = 0;

    public String getDefaultExtension() {
        return "wiki";
    }

    private String heading1(String name) {
        return "=" + name + "=\n";
    }

    private String heading2(String name) {
        return "==" + name + "==\n";
    }

    private String row(String ... cells) {
        StringBuilder result = new StringBuilder();
        boolean hasContent = false;
        for (String cell : cells) {
            if (cell.equals("")) {
                cell = " ";
            }
            result.append("||" + cell);
            hasContent = true;
        }
        if (hasContent) {
            result.append("||\n");
        }
        return result.toString();
    }

    private String code(String code) {
        return code.equals("") ? " " : "{{{" + code + "}}}";
    }

    public void generateHeader(Writer output, RulesetDescription ruleSet) throws IOException {
        output.write(this.heading1(ruleSet.name()));
        output.write(this.heading2(ruleSet.synopsis()));
    }

    public void generateFooter(Writer output, RulesetDescription ruleSet) {
    }

    public void generateRuleDocumentation(Writer output, RuleDescription anno) throws IOException {
        if (this.countRules == 0) {
            output.write(this.row("", "Rule", "Synopsis", "Reason", "Matches", "Substitutes"));
        }
        output.write(this.row("" + this.countRules++, anno.name(), anno.synopsis(), anno.reason(), this.code(anno.matches()), this.code(anno.substitutes())));
    }

    public void finish(Writer out) {
    }
}

