/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IhtmlMessageType implements MessageTypeInt
{
    BAD_ATTRIB("%s: Element %s has bad attribute %s with value `%s`", MessageLevel.ERROR),
    BAD_ELEMENT("%s: Unrecognized element %s", MessageLevel.ERROR),
    DUPLICATE_IDENTIFIER("%s: Identifier %s already declared at %s", MessageLevel.FATAL_ERROR),
    DUPLICATE_MESSAGE("%s: Message %s masks one at %s", MessageLevel.ERROR),
    DUPLICATE_PLACEHOLDER("%s: Placeholder %s masks one at %s", MessageLevel.ERROR),
    FOLDING_ELEMENT("%s: folding element %s into parent", MessageLevel.WARNING),
    IHTML_IN_MESSAGE_OUTSIDE_PLACEHOLDER("%s: %s in message outside placeholder", MessageLevel.ERROR),
    ILLEGAL_NAME("%s: illegal name %s", MessageLevel.ERROR),
    INAPPROPRIATE_CONTENT("%s: cannot have content inside %s", MessageLevel.ERROR),
    MALFORMED_MESSAGE("%s: Message %s is malformed", MessageLevel.ERROR),
    MALFORMED_URI("%s: URI %s is malformed", MessageLevel.ERROR),
    MISPLACED_ELEMENT("%s: Element %s not allowed inside %s", MessageLevel.ERROR),
    MISSING_ATTRIB("%s: Element %s is missing required attribute %s", MessageLevel.ERROR),
    MISSING_PLACEHOLDER("%s: No such message with name %s", MessageLevel.ERROR),
    NESTED_MESSAGE("%s: Message nested inside another at %s", MessageLevel.ERROR),
    ORPHANED_PLACEHOLDER("%s: Placeholder not inside a message", MessageLevel.ERROR),
    ORPHANED_PLACEHOLDER_END("%s: Placeholder end does not match an open", MessageLevel.ERROR),
    UNCLOSED_PLACEHOLDER("%s: Placeholder not closed", MessageLevel.ERROR),
    UNKNOWN_TAG("%s: removing unknown tag %s", MessageLevel.WARNING),
    UNSAFE_TAG("%s: removing disallowed tag %s", MessageLevel.WARNING),
    UNTRANSLATED_MESSAGE("%s: No such message with name %s in locale %s", MessageLevel.WARNING);

    private final String formatString;
    private final MessageLevel level;
    private final int paramCount;

    private IhtmlMessageType(String formatString, MessageLevel level) {
        this.formatString = formatString;
        this.level = level;
        this.paramCount = MessageType.formatStringArity(formatString);
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    @Override
    public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
        MessageType.formatMessage(this.formatString, parts, context, out);
    }

    @Override
    public MessageLevel getLevel() {
        return this.level;
    }
}

