/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.jboss.jms.client.container.ConnectionFailureListener;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;

public class ConsolidatedRemotingConnectionListener
implements ConnectionListener {
    private static final Logger log = Logger.getLogger(ConsolidatedRemotingConnectionListener.class);
    private ConnectionState state;
    private ExceptionListener jmsExceptionListener;
    private ConnectionFailureListener remotingListener;
    private boolean started;
    private JMSException jmsException;
    private Object jmsExceptionLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleConnectionException(Throwable throwable, Client client) {
        if (!this.started) {
            return;
        }
        boolean forwardToJMSListener = true;
        ExceptionListener jmsListenerCopy = this.jmsExceptionListener;
        if (this.remotingListener != null) {
            try {
                log.trace((Object)(this + " forwarding remoting failure \"" + throwable + "\" to " + this.remotingListener));
                forwardToJMSListener = !this.remotingListener.handleConnectionException(throwable, client);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to forward " + throwable + " to " + this.remotingListener), (Throwable)e);
            }
        }
        if (forwardToJMSListener) {
            Object object = this.jmsExceptionLock;
            synchronized (object) {
                if (throwable instanceof Error) {
                    String msg = "Caught Error on underlying remoting connection";
                    log.error((Object)(this + ": " + "Caught Error on underlying remoting connection"), throwable);
                    this.jmsException = new JMSException("Caught Error on underlying remoting connection: " + throwable.getMessage());
                } else if (throwable instanceof Exception) {
                    Exception e = (Exception)throwable;
                    this.jmsException = new JMSException("Failure on underlying remoting connection");
                    this.jmsException.setLinkedException(e);
                } else {
                    String msg = "Caught Throwable on underlying remoting connection";
                    log.error((Object)(this + ": " + "Caught Throwable on underlying remoting connection"), throwable);
                    this.jmsException = new JMSException("Caught Throwable on underlying remoting connection: " + throwable.getMessage());
                }
                if (jmsListenerCopy != null) {
                    jmsListenerCopy.onException(this.jmsException);
                    this.jmsException = null;
                }
            }
        }
    }

    public synchronized void setDelegateListener(ConnectionFailureListener l) {
        log.trace((Object)(this + " setting delegate listener " + l));
        if (this.remotingListener != null) {
            throw new IllegalStateException("There is already a connection listener for the connection");
        }
        this.remotingListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addJMSExceptionListener(ExceptionListener listener) {
        log.trace((Object)(this + " adding JMS exception listener " + listener + " current exception: " + (Object)((Object)this.jmsException)));
        Object object = this.jmsExceptionLock;
        synchronized (object) {
            this.jmsExceptionListener = listener;
            if (this.jmsException != null) {
                JMSException copy = this.jmsException;
                this.jmsException = null;
                this.notifyJMSExceptionListener(listener, copy);
            }
        }
    }

    private void notifyJMSExceptionListener(final ExceptionListener l, final JMSException ex) {
        new Thread(){

            public void run() {
                l.onException(ex);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExceptionListener getJMSExceptionListener() {
        Object object = this.jmsExceptionLock;
        synchronized (object) {
            return this.jmsExceptionListener;
        }
    }

    public synchronized void clear() {
        this.clearJmsExceptionListener();
        this.remotingListener = null;
        log.trace((Object)(this + " cleared"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearJmsExceptionListener() {
        Object object = this.jmsExceptionLock;
        synchronized (object) {
            this.jmsExceptionListener = null;
        }
    }

    public void setConnectionState(ConnectionState state) {
        this.state = state;
    }

    public String toString() {
        if (this.state == null) {
            return "ConsolidatedListener(UNINITIALIZED)";
        }
        return this.state + ".ConsolidatedListener";
    }

    public void start() {
        this.started = true;
    }
}

