/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.spi.ExceptionHandler;
import org.jboss.virtual.spi.TempStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreInitializeVFSContexts {
    protected Logger log = Logger.getLogger(this.getClass());
    private Map<URL, ExceptionHandler> initializedVFSContexts;
    private Map<URL, TempStore> tempStores;
    private boolean holdReference;
    private List<VFS> references;

    public void start() throws Exception {
        VFS vfs;
        URL url;
        HashMap<URL, VFS> refs = new HashMap<URL, VFS>();
        if (this.initializedVFSContexts != null && !this.initializedVFSContexts.isEmpty()) {
            for (Map.Entry<URL, Object> entry : this.initializedVFSContexts.entrySet()) {
                url = entry.getKey();
                vfs = VFS.getVFS(url);
                ExceptionHandler eh = (ExceptionHandler)entry.getValue();
                if (eh != null) {
                    vfs.setExceptionHandler(eh);
                }
                this.log.debug((Object)("Initialized Virtual File: " + vfs.getRoot()));
                refs.put(url, vfs);
            }
        }
        if (this.tempStores != null && !this.tempStores.isEmpty()) {
            for (Map.Entry<URL, Object> entry : this.tempStores.entrySet()) {
                TempStore ts;
                url = entry.getKey();
                vfs = (VFS)refs.get(url);
                if (vfs == null) {
                    vfs = VFS.getVFS(url);
                    this.log.debug((Object)("Initialized Virtual File: " + vfs.getRoot()));
                    refs.put(url, vfs);
                }
                if ((ts = (TempStore)entry.getValue()) == null) continue;
                vfs.setTempStore(ts);
            }
        }
        if (this.holdReference) {
            this.references = new ArrayList(refs.values());
        }
    }

    public void stop() {
        if (this.references != null) {
            this.references.clear();
        }
    }

    public List<VFS> getReferences() {
        if (this.references == null || this.references.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.references);
    }

    public void setInitializedVFSContexts(Map<URL, ExceptionHandler> initializedVFSContexts) {
        this.initializedVFSContexts = initializedVFSContexts;
    }

    public void setTempStores(Map<URL, TempStore> tempStores) {
        this.tempStores = tempStores;
    }

    public void setHoldReference(boolean holdReference) {
        this.holdReference = holdReference;
    }
}

