/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import org.jboss.aop.util.Advisable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistMethodHashing {
    public static long methodHash(CtMethod method) {
        try {
            CtClass[] parameterTypes = method.getParameterTypes();
            String methodDesc = method.getName() + "(";
            for (int j = 0; j < parameterTypes.length; ++j) {
                methodDesc = methodDesc + JavassistMethodHashing.getTypeString(parameterTypes[j]);
            }
            methodDesc = methodDesc + ")" + JavassistMethodHashing.getTypeString(method.getReturnType());
            long hash = 0L;
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
            MessageDigest messagedigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
            dataoutputstream.writeUTF(methodDesc);
            dataoutputstream.flush();
            byte[] abyte0 = messagedigest.digest();
            for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                hash += (long)(abyte0[j] & 0xFF) << j * 8;
            }
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long constructorHash(CtConstructor method) {
        try {
            CtClass[] parameterTypes = method.getParameterTypes();
            String methodDesc = method.getDeclaringClass().getName() + "(";
            for (int j = 0; j < parameterTypes.length; ++j) {
                methodDesc = methodDesc + JavassistMethodHashing.getTypeString(parameterTypes[j]);
            }
            methodDesc = methodDesc + ")";
            long hash = 0L;
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
            MessageDigest messagedigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
            dataoutputstream.writeUTF(methodDesc);
            dataoutputstream.flush();
            byte[] abyte0 = messagedigest.digest();
            for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                hash += (long)(abyte0[j] & 0xFF) << j * 8;
            }
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String getTypeString(CtClass cl) throws Exception {
        if (cl.equals(CtClass.byteType)) {
            return "B";
        }
        if (cl.equals(CtClass.charType)) {
            return "C";
        }
        if (cl.equals(CtClass.doubleType)) {
            return "D";
        }
        if (cl.equals(CtClass.floatType)) {
            return "F";
        }
        if (cl.equals(CtClass.intType)) {
            return "I";
        }
        if (cl.equals(CtClass.longType)) {
            return "J";
        }
        if (cl.equals(CtClass.shortType)) {
            return "S";
        }
        if (cl.equals(CtClass.booleanType)) {
            return "Z";
        }
        if (cl.equals(CtClass.voidType)) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + JavassistMethodHashing.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    private static void addDeclaredMethods(HashMap<Long, CtMethod> advised, CtClass superclass) throws Exception {
        CtMethod[] declaredMethods = superclass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            if (!superclass.isInterface() && !Advisable.isAdvisable(declaredMethods[i])) continue;
            Long hash = JavassistMethodHashing.methodHash(declaredMethods[i]);
            if (Modifier.isVolatile((int)declaredMethods[i].getModifiers())) {
                advised.remove(hash);
                continue;
            }
            advised.put((long)hash, declaredMethods[i]);
        }
    }

    private static void populateMethodTables(HashMap<Long, CtMethod> advised, CtClass superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.getName().equals("java.lang.Object")) {
            return;
        }
        if (superclass.isInterface()) {
            CtClass[] ifs = superclass.getInterfaces();
            for (int i = 0; i < ifs.length; ++i) {
                JavassistMethodHashing.populateMethodTables(advised, ifs[i]);
            }
            JavassistMethodHashing.addDeclaredMethods(advised, superclass);
        } else {
            JavassistMethodHashing.populateMethodTables(advised, superclass.getSuperclass());
            JavassistMethodHashing.addDeclaredMethods(advised, superclass);
        }
    }

    public static HashMap<Long, CtMethod> getMethodMap(CtClass clazz) throws Exception {
        HashMap<Long, CtMethod> map = new HashMap<Long, CtMethod>();
        JavassistMethodHashing.populateMethodTables(map, clazz);
        return map;
    }

    public static HashMap<Long, CtMethod> getDeclaredMethodMap(CtClass clazz) throws Exception {
        HashMap<Long, CtMethod> map = new HashMap<Long, CtMethod>();
        JavassistMethodHashing.addDeclaredMethods(map, clazz);
        return map;
    }
}

