/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;
import org.hibernate.util.StringHelper;

public class SAPDBDialect
extends Dialect {
    public SAPDBDialect() {
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(-5, "fixed(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "fixed(3,0)");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "long byte");
        this.registerColumnType(2, "fixed($p,$s)");
        this.registerColumnType(2005, "long varchar");
        this.registerColumnType(2004, "long byte");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction("pi", Hibernate.DOUBLE));
        this.registerFunction("power", new StandardSQLFunction("power"));
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cosh", new StandardSQLFunction("cosh", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("sinh", new StandardSQLFunction("sinh", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("tanh", new StandardSQLFunction("tanh", Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction("radians", Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("degrees", Hibernate.DOUBLE));
        this.registerFunction("atan2", new StandardSQLFunction("atan2", Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("greatest", new StandardSQLFunction("greatest"));
        this.registerFunction("least", new StandardSQLFunction("least"));
        this.registerFunction("time", new StandardSQLFunction("time", Hibernate.TIME));
        this.registerFunction("timestamp", new StandardSQLFunction("timestamp", Hibernate.TIMESTAMP));
        this.registerFunction("date", new StandardSQLFunction("date", Hibernate.DATE));
        this.registerFunction("microsecond", new StandardSQLFunction("microsecond", Hibernate.INTEGER));
        this.registerFunction("second", new SQLFunctionTemplate(Hibernate.INTEGER, "second(?1)"));
        this.registerFunction("minute", new SQLFunctionTemplate(Hibernate.INTEGER, "minute(?1)"));
        this.registerFunction("hour", new SQLFunctionTemplate(Hibernate.INTEGER, "hour(?1)"));
        this.registerFunction("day", new SQLFunctionTemplate(Hibernate.INTEGER, "day(?1)"));
        this.registerFunction("month", new SQLFunctionTemplate(Hibernate.INTEGER, "month(?1)"));
        this.registerFunction("year", new SQLFunctionTemplate(Hibernate.INTEGER, "year(?1)"));
        this.registerFunction("extract", new SQLFunctionTemplate(Hibernate.INTEGER, "?1(?3)"));
        this.registerFunction("dayname", new StandardSQLFunction("dayname", Hibernate.STRING));
        this.registerFunction("monthname", new StandardSQLFunction("monthname", Hibernate.STRING));
        this.registerFunction("dayofmonth", new StandardSQLFunction("dayofmonth", Hibernate.INTEGER));
        this.registerFunction("dayofweek", new StandardSQLFunction("dayofweek", Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", Hibernate.INTEGER));
        this.registerFunction("weekofyear", new StandardSQLFunction("weekofyear", Hibernate.INTEGER));
        this.registerFunction("replace", new StandardSQLFunction("replace", Hibernate.STRING));
        this.registerFunction("translate", new StandardSQLFunction("translate", Hibernate.STRING));
        this.registerFunction("lpad", new StandardSQLFunction("lpad", Hibernate.STRING));
        this.registerFunction("rpad", new StandardSQLFunction("rpad", Hibernate.STRING));
        this.registerFunction("substr", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("initcap", new StandardSQLFunction("initcap", Hibernate.STRING));
        this.registerFunction("lower", new StandardSQLFunction("lower", Hibernate.STRING));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim", Hibernate.STRING));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim", Hibernate.STRING));
        this.registerFunction("lfill", new StandardSQLFunction("ltrim", Hibernate.STRING));
        this.registerFunction("rfill", new StandardSQLFunction("rtrim", Hibernate.STRING));
        this.registerFunction("soundex", new StandardSQLFunction("soundex", Hibernate.STRING));
        this.registerFunction("upper", new StandardSQLFunction("upper", Hibernate.STRING));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.STRING));
        this.registerFunction("index", new StandardSQLFunction("index", Hibernate.INTEGER));
        this.registerFunction("value", new StandardSQLFunction("value"));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "||", ")"));
        this.registerFunction("substring", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("locate", new StandardSQLFunction("index", Hibernate.INTEGER));
        this.registerFunction("coalesce", new StandardSQLFunction("value"));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuffer res = new StringBuffer(30).append(" foreign key ").append(constraintName).append(" (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(StringHelper.join(", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    @Override
    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " primary key ";
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dual";
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    @Override
    public String getQuerySequencesString() {
        return "select sequence_name from domain.sequences";
    }

    @Override
    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    @Override
    public boolean supportsTemporaryTables() {
        return true;
    }

    @Override
    public String getCreateTemporaryTablePostfix() {
        return "ignore rollback";
    }

    @Override
    public String generateTemporaryTableName(String baseTableName) {
        return "temp." + super.generateTemporaryTableName(baseTableName);
    }
}

