/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.HashSet;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.deployers.metadata.processor.JBossMetaDataProcessorFactory;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.process.chain.ejb.jboss.JBossMetaDataProcessorChain;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;
import org.jboss.metadata.validation.chain.ValidatorChain;

public class Ejb3MetadataProcessingDeployer
extends AbstractDeployer {
    private static final Logger log = Logger.getLogger(Ejb3MetadataProcessingDeployer.class);
    private static final String INPUT = AttachmentNames.MERGED_METADATA;
    public static final String OUTPUT = AttachmentNames.PROCESSED_METADATA;
    private Set<JBossMetaDataProcessorFactory<JBossMetaData>> processorFactories = new HashSet<JBossMetaDataProcessorFactory<JBossMetaData>>();
    private ValidatorChain<JBossMetaData> validatorChain;

    public Ejb3MetadataProcessingDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(INPUT);
        this.addOutput(OUTPUT);
    }

    public void deploy(DeploymentUnit du) throws DeploymentException {
        JBossMetaData md = (JBossMetaData)du.getAttachment(INPUT, JBossMetaData.class);
        if (md == null) {
            return;
        }
        if (!md.isEJB3x()) {
            return;
        }
        JBossMetaDataProcessorChain chain = new JBossMetaDataProcessorChain();
        for (JBossMetaDataProcessorFactory<JBossMetaData> processorFactory : this.processorFactories) {
            JBossMetaDataProcessor<JBossMetaData> processor = processorFactory.create(du);
            chain.addProcessor(processor);
        }
        JBossMetaData processedMetadata = chain.process(md);
        if (this.validatorChain != null) {
            this.validatorChain.validate(processedMetadata);
        }
        du.addAttachment(OUTPUT, (Object)processedMetadata, JBossMetaData.class);
    }

    public void addProcessorFactory(JBossMetaDataProcessorFactory<JBossMetaData> processorFactory) {
        this.processorFactories.add(processorFactory);
    }

    public void removeProcessorFactory(JBossMetaDataProcessorFactory<JBossMetaData> processorFactory) {
        this.processorFactories.remove(processorFactory);
    }

    public void setValidatorChain(ValidatorChain<JBossMetaData> validatorChain) {
        this.validatorChain = validatorChain;
    }

    public ValidatorChain<JBossMetaData> getValidatorChain() {
        return this.validatorChain;
    }
}

