/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.CompletionStatus;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class CompletionStatusHandler
extends AbstractHandler {
    public static final String TAG_NAME = "completionStatus";

    protected CompletionStatusHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        CompletionStatus obj = new CompletionStatus();
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        CompletionStatus status = (CompletionStatus)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String statusValue = status.getValue();
        if (statusValue != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(statusValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        CompletionStatus status = new CompletionStatus();
        status.setValue("status:fromKey_incomplete");
        System.out.println();
        RegistryObject regObject = status;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

