/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.response.PublisherDetail;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PublisherDetailHandler
extends AbstractHandler {
    public static final String TAG_NAME = "publisherDetail";
    private HandlerMaker maker = null;

    protected PublisherDetailHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        PublisherDetail obj = new PublisherDetail();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        String truncValue = element.getAttribute("truncated");
        if (truncValue != null) {
            obj.setTruncated(truncValue.equalsIgnoreCase("true"));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "publisher");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("publisher");
            obj.addPublisher((Publisher)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector vector;
        PublisherDetail detail = (PublisherDetail)object;
        String generic = detail.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        String operator = detail.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        boolean truncated = detail.isTruncated();
        if (truncated) {
            element.setAttribute("truncated", "true");
        }
        if ((vector = detail.getPublisherVector()) != null && vector.size() > 0) {
            handler = this.maker.lookup("publisher");
            for (int i = 0; i < vector.size(); ++i) {
                handler.marshal((Publisher)vector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        Publisher publisher = new Publisher();
        publisher.setPublisherID("bcrosby");
        publisher.setName("Bing Crosby");
        publisher.setEmailAddress("bcrosby@juddi.org");
        publisher.setAdmin(true);
        PublisherDetail detail = new PublisherDetail();
        detail.setGeneric("1.0");
        detail.setOperator("jUDDI.org");
        detail.setTruncated(false);
        detail.addPublisher(publisher);
        detail.addPublisher(publisher);
        System.out.println();
        RegistryObject regObject = detail;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

