/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureMetaDataImpl
implements StructureMetaData,
Externalizable {
    private static final long serialVersionUID = 2341637762171510800L;
    private List<ContextInfo> contexts = new CopyOnWriteArrayList<ContextInfo>();

    public void addContext(ContextInfo context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        String path = context.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Context has no path");
        }
        for (ContextInfo other : this.contexts) {
            if (!path.equals(other.getPath())) continue;
            throw new IllegalStateException("Context already exists with path '" + path + "' contexts=" + this.getContexts());
        }
        this.contexts.add(context);
    }

    public ContextInfo getContext(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        for (ContextInfo context : this.contexts) {
            if (!path.equals(context.getPath())) continue;
            return context;
        }
        return null;
    }

    public void removeContext(ContextInfo context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.contexts.remove(context);
    }

    public void removeContext(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        for (ContextInfo context : this.contexts) {
            if (!path.equals(context.getPath())) continue;
            this.contexts.remove(context);
        }
    }

    public List<ContextInfo> getContexts() {
        return this.contexts;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("{");
        this.toString(builder);
        builder.append("}");
        return builder.toString();
    }

    protected void toString(StringBuilder builder) {
        builder.append("contexts=").append(this.contexts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StructureMetaData)) {
            return false;
        }
        StructureMetaData other = (StructureMetaData)obj;
        List<ContextInfo> thisContexts = this.getContexts();
        List otherContexts = other.getContexts();
        if (thisContexts == null) {
            return otherContexts == null;
        }
        return ((Object)thisContexts).equals(otherContexts);
    }

    public int hashCode() {
        List<ContextInfo> contexts = this.getContexts();
        if (contexts == null) {
            return 0;
        }
        return ((Object)contexts).hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.contexts = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getContexts());
    }
}

