/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpHandlerNotDefinedException;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpPortal;
import org.opennms.protocols.snmp.SnmpRequest;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimer;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpSession {
    public static final int ERROR_TIMEOUT = -1;
    public static final int ERROR_IOEXCEPTION = -2;
    public static final int ERROR_ENCODING = -3;
    public static final int ERROR_RUNTIME = -4;
    private Map m_requestsMap = new HashMap();
    private SnmpPeer m_peer;
    private SnmpTimer m_timer;
    private SnmpHandler m_defHandler;
    AsnEncoder m_encoder;
    private Object m_sync = new Object();
    private boolean m_stopRun;
    private SnmpPortal m_portal;
    private static final int EXPIRED_REQUEST_CLEANUP_FREQUENCY = 30000;

    private ByteArrayInfo encode(SnmpPeer peer, SnmpPduPacket pdu) throws SnmpPduEncodingException, AsnEncodingException {
        SnmpOctetString community;
        SnmpParameters parms = peer.getParameters();
        AsnEncoder encoder = peer.getParameters().getEncoder();
        int offset = 0;
        byte[] buf = new byte[16384];
        SnmpInt32 version = new SnmpInt32(parms.getVersion());
        offset = version.encodeASN(buf, offset, encoder);
        if (pdu.getCommand() == 163) {
            String wrComm = parms.getWriteCommunity();
            if (wrComm == null) {
                throw new SnmpPduEncodingException("Requested SET but there is no write community");
            }
            community = new SnmpOctetString(wrComm.getBytes());
        } else {
            community = new SnmpOctetString(parms.getReadCommunity().getBytes());
        }
        offset = community.encodeASN(buf, offset, encoder);
        int pivot = offset = pdu.encodeASN(buf, offset, encoder);
        offset = encoder.buildHeader(buf, offset, (byte)48, pivot);
        SnmpUtil.rotate(buf, 0, pivot, offset);
        return new ByteArrayInfo(buf, offset);
    }

    private ByteArrayInfo encode(SnmpPduTrap pdu) throws AsnEncodingException {
        SnmpPeer peer = this.m_peer;
        SnmpParameters parms = peer.getParameters();
        int offset = 0;
        byte[] buf = new byte[16384];
        SnmpInt32 version = new SnmpInt32(parms.getVersion());
        offset = version.encodeASN(buf, offset, this.m_encoder);
        SnmpOctetString community = new SnmpOctetString(parms.getReadCommunity().getBytes());
        offset = community.encodeASN(buf, offset, this.m_encoder);
        int pivot = offset = pdu.encodeASN(buf, offset, this.m_encoder);
        offset = this.m_encoder.buildHeader(buf, offset, (byte)48, pivot);
        SnmpUtil.rotate(buf, 0, pivot, offset);
        return new ByteArrayInfo(buf, offset);
    }

    SnmpTimer getTimer() {
        return this.m_timer;
    }

    void transmit(SnmpRequest req) throws SnmpPduEncodingException, AsnEncodingException, IOException {
        SnmpPduPacket pdu = null;
        SnmpPduTrap trap = null;
        SnmpPeer peer = this.m_peer;
        SnmpParameters parms = peer.getParameters();
        if (req.getPdu() instanceof SnmpPduPacket) {
            pdu = (SnmpPduPacket)req.getPdu();
            if (pdu.getPeer() != null) {
                peer = pdu.getPeer();
            }
        } else if (req.getPdu() instanceof SnmpPduTrap) {
            trap = (SnmpPduTrap)req.getPdu();
        }
        if (pdu != null) {
            switch (pdu.getCommand()) {
                case 165: 
                case 166: 
                case 167: 
                case 168: {
                    if (parms.getVersion() >= 1) break;
                    throw new SnmpPduEncodingException("Cannot send pdu, invalid SNMP version");
                }
            }
            ByteArrayInfo msg = this.encode(peer, pdu);
            this.m_portal.send(peer, msg.array(), msg.size());
        } else if (trap != null) {
            ByteArrayInfo msg = this.encode(trap);
            this.m_portal.send(this.m_peer, msg.array(), msg.size());
        } else {
            throw new SnmpPduEncodingException("Invalid PDU type passed to method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snmpInternalError(SnmpRequest request, int errorCode) {
        if (request.isExpired()) {
            return;
        }
        Integer id = request.getRequestID();
        Map map = this.m_requestsMap;
        synchronized (map) {
            Object tmp = this.m_requestsMap.get(id);
            if (tmp != request) {
                return;
            }
            this.m_requestsMap.remove(id);
            request.setExpired(true);
        }
        try {
            request.getHandler().snmpInternalError(this, errorCode, request.getPdu());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTimeoutError(SnmpRequest request) {
        if (request.isExpired()) {
            return;
        }
        Integer id = request.getRequestID();
        Map map = this.m_requestsMap;
        synchronized (map) {
            Object tmp = this.m_requestsMap.get(id);
            if (tmp != request) {
                return;
            }
            this.m_requestsMap.remove(id);
            request.setExpired(true);
        }
        try {
            request.getHandler().snmpTimeoutError(this, request.getPdu());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SnmpSession(InetAddress peer) throws SocketException {
        this(new SnmpPeer(peer));
    }

    public SnmpSession(SnmpPeer peer) throws SocketException {
        this(peer, 0, 65536, 65536);
    }

    public SnmpSession(InetAddress peer, SnmpParameters params) throws SocketException {
        this(peer);
        this.m_peer.setParameters(params);
    }

    public SnmpSession(SnmpPeer peer, int threadPoolSize, int receiveBuffer, int sendBuffer) throws SocketException {
        this.m_peer = peer;
        this.m_encoder = peer.getParameters().getEncoder();
        this.m_portal = new SnmpPortal(new SessionHandler(), this.m_encoder, peer.getServerPort(), peer.getServerAddress(), threadPoolSize, receiveBuffer, sendBuffer);
        this.m_timer = new SnmpTimer();
        this.m_timer.schedule(new CleanupRequest(), 30000L);
    }

    public SnmpHandler getDefaultHandler() {
        return this.m_defHandler;
    }

    public void setDefaultHandler(SnmpHandler hdl) {
        this.m_defHandler = hdl;
    }

    public SnmpPeer getPeer() {
        return this.m_peer;
    }

    public void setPeer(SnmpPeer peer) {
        this.m_peer = peer;
        this.setAsnEncoder(peer.getParameters().getEncoder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutstandingCount() {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
            Map map = this.m_requestsMap;
            synchronized (map) {
                this.cleanupExpiredRequests();
                return this.m_requestsMap.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int requestId) {
        Integer requestID = new Integer(requestId);
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
            Map map = this.m_requestsMap;
            synchronized (map) {
                SnmpRequest req = (SnmpRequest)this.m_requestsMap.remove(requestID);
                if (req != null) {
                    req.setExpired(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(SnmpPduPacket pdu, SnmpHandler handler) {
        if (handler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        Integer requestId = new Integer(pdu.getRequestId());
        SnmpRequest req = new SnmpRequest(this, requestId, pdu, handler);
        boolean shouldHoldRequest = !req.isTrap();
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
            if (shouldHoldRequest) {
                Map map = this.m_requestsMap;
                synchronized (map) {
                    SnmpRequest old = (SnmpRequest)this.m_requestsMap.get(requestId);
                    if (old != null && !old.isExpired()) {
                        throw new IllegalStateException("Session has an active request with the same id");
                    }
                    this.m_requestsMap.put(requestId, req);
                }
            }
        }
        req.run();
        return shouldHoldRequest ? 0 : requestId;
    }

    public int send(SnmpPduPacket pdu) {
        return this.send(pdu, this.m_defHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(SnmpPduTrap pdu, SnmpHandler handler) {
        if (handler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        SnmpRequest req = new SnmpRequest(this, pdu, handler);
        req.run();
        return 0;
    }

    public int send(SnmpPduTrap pdu) {
        return this.send(pdu, this.m_defHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.m_sync;
        synchronized (object) {
            return this.m_stopRun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("The session is already closed");
            }
            this.m_stopRun = true;
        }
        this.m_timer.cancel(true);
        this.m_portal.close();
    }

    public void setAsnEncoder(AsnEncoder encoder) {
        this.m_encoder = encoder;
        this.m_portal.setAsnEncoder(encoder);
    }

    public AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    public static void registerSyntaxObject(SnmpSyntax object) {
        SnmpUtil.registerSyntax(object);
    }

    private void cleanupExpiredRequests() {
        if (!this.m_requestsMap.isEmpty()) {
            Iterator iter = this.m_requestsMap.values().iterator();
            while (iter.hasNext()) {
                SnmpRequest req = (SnmpRequest)iter.next();
                if (!req.isExpired()) continue;
                iter.remove();
            }
        }
    }

    private class CleanupRequest
    implements Runnable {
        private CleanupRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SnmpSession.this.m_stopRun) {
                return;
            }
            try {
                Map map = SnmpSession.this.m_requestsMap;
                synchronized (map) {
                    SnmpSession.this.cleanupExpiredRequests();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SnmpSession.this.m_timer.schedule(this, 30000L);
        }
    }

    private static class ByteArrayInfo {
        private byte[] m_buf;
        private int m_length;

        public ByteArrayInfo(byte[] buf, int length) {
            this.m_buf = buf;
            this.m_length = length;
        }

        public byte[] array() {
            return this.m_buf;
        }

        public int size() {
            return this.m_length;
        }
    }

    private class SessionHandler
    implements SnmpPacketHandler {
        private SessionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processSnmpMessage(InetAddress agent, int port, SnmpInt32 version, SnmpOctetString community, int pduType, SnmpPduPacket pdu) {
            Integer key = new Integer(pdu.getRequestId());
            SnmpRequest req = null;
            Map map = SnmpSession.this.m_requestsMap;
            synchronized (map) {
                req = (SnmpRequest)SnmpSession.this.m_requestsMap.remove(key);
                if (req == null) {
                    return;
                }
                req.setExpired(true);
            }
            try {
                req.getHandler().snmpReceivedPdu(SnmpSession.this, pdu.getCommand(), pdu);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        @Override
        public void processSnmpTrap(InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) throws SnmpPduEncodingException {
            throw new SnmpPduEncodingException("Invalid PDU Type for session");
        }

        @Override
        public void processBadDatagram(DatagramPacket p) {
        }

        @Override
        public void processException(Exception e) {
        }
    }
}

