/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.exception;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;

public class ThrowableUtil {
    private ThrowableUtil() {
    }

    public static String getAllMessages(Throwable t, boolean includeExceptionName) {
        StringBuffer ret_message = new StringBuffer();
        if (t != null) {
            String[] msgs = ThrowableUtil.getAllMessagesArray(t, includeExceptionName);
            ret_message.append(msgs[0]);
            for (int i = 1; i < msgs.length; ++i) {
                ret_message.append(" -> ");
                ret_message.append(msgs[i]);
            }
        } else {
            ret_message.append(">> exception was null <<");
        }
        return ret_message.toString();
    }

    public static String getAllMessages(Throwable t) {
        return ThrowableUtil.getAllMessages(t, true);
    }

    public static String[] getAllMessagesArray(Throwable t, boolean includeExceptionName) {
        ArrayList<String> list = new ArrayList<String>();
        if (t != null) {
            String msg = includeExceptionName ? t.getClass().getName() + ":" + t.getMessage() : t.getMessage();
            if (t instanceof SQLException) {
                msg = msg + "[SQLException=" + ThrowableUtil.getAllSqlExceptionMessages((SQLException)t, false) + "]";
            }
            list.add(msg);
            while (t.getCause() != null && t != t.getCause()) {
                t = t.getCause();
                msg = includeExceptionName ? t.getClass().getName() + ":" + t.getMessage() : t.getMessage();
                if (t instanceof SQLException) {
                    msg = msg + "[SQLException=" + ThrowableUtil.getAllSqlExceptionMessages((SQLException)t, false) + "]";
                }
                list.add(msg);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getAllMessagesArray(Throwable t) {
        return ThrowableUtil.getAllMessagesArray(t, true);
    }

    public static String getAllSqlExceptionMessages(SQLException t, boolean includeExceptionName) {
        StringBuffer ret_message = new StringBuffer();
        if (t != null) {
            String[] msgs = ThrowableUtil.getAllSqlExceptionMessagesArray(t, includeExceptionName);
            ret_message.append(msgs[0]);
            for (int i = 1; i < msgs.length; ++i) {
                ret_message.append(" -> ");
                ret_message.append(msgs[i]);
            }
        } else {
            ret_message.append(">> sql exception was null <<");
        }
        return ret_message.toString();
    }

    public static String getAllSqlExceptionMessages(SQLException t) {
        return ThrowableUtil.getAllSqlExceptionMessages(t, true);
    }

    public static String[] getAllSqlExceptionMessagesArray(SQLException t, boolean includeExceptionName) {
        ArrayList<String> list = new ArrayList<String>();
        if (t != null) {
            if (includeExceptionName) {
                list.add(t.getClass().getName() + ":" + t.getMessage());
            } else {
                list.add(t.getMessage());
            }
            while (t.getNextException() != null && t != t.getNextException()) {
                t = t.getNextException();
                String msg = includeExceptionName ? t.getClass().getName() + ":" + t.getMessage() : t.getMessage();
                list.add(msg + "(error-code=" + t.getErrorCode() + ",sql-state=" + t.getSQLState() + ")");
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getAllSqlExceptionMessagesArray(SQLException t) {
        return ThrowableUtil.getAllSqlExceptionMessagesArray(t, true);
    }

    public static String getStackAsString(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public static String getRootMessage(Throwable t) {
        while (t.getCause() != null && t != t.getCause()) {
            t = t.getCause();
        }
        return t.getMessage();
    }
}

