/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.DynamicQuery;

class FindServiceByNameQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindServiceByNameQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindServiceByNameQuery = FindServiceByNameQuery.class$("org.apache.juddi.datastore.jdbc.FindServiceByNameQuery")) : class$org$apache$juddi$datastore$jdbc$FindServiceByNameQuery));
    static String selectSQL;
    static String tablePrefix;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindServiceByNameQuery;

    FindServiceByNameQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, Vector names, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindServiceByNameQuery.appendWhere(sql, businessKey, names, qualifiers);
        FindServiceByNameQuery.appendIn(sql, keysIn);
        FindServiceByNameQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            Vector<String> vector = keysOut;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessService ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessService Statement: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void appendWhere(DynamicQuery sql, String businessKey, Vector names, FindQualifiers qualifiers) {
        sql.append("WHERE N.SERVICE_KEY = S.SERVICE_KEY ");
        if (businessKey != null && businessKey.length() > 0) {
            sql.append("AND S.BUSINESS_KEY = ? ");
            sql.addValue(businessKey);
        }
        if (names != null) {
            int nameSize = names.size();
            if (nameSize > 0) {
                sql.append("AND (");
                for (int i = 0; i < nameSize; ++i) {
                    Name name = (Name)names.elementAt(i);
                    String text = name.getValue();
                    String lang = name.getLanguageCode();
                    if (text == null || text.length() <= 0) continue;
                    if (qualifiers == null) {
                        sql.append("(UPPER(NAME) LIKE ?");
                        sql.addValue(text.endsWith("%") ? text.toUpperCase() : text.toUpperCase() + "%");
                    } else if (qualifiers.caseSensitiveMatch && qualifiers.exactNameMatch) {
                        sql.append("(NAME = ?");
                        sql.addValue(text);
                    } else if (!qualifiers.caseSensitiveMatch && qualifiers.exactNameMatch) {
                        sql.append("(UPPER(NAME) = ?");
                        sql.addValue(text.toUpperCase());
                    } else if (qualifiers.caseSensitiveMatch && !qualifiers.exactNameMatch) {
                        sql.append("(NAME LIKE ?");
                        sql.addValue(text.endsWith("%") ? text : text + "%");
                    } else if (!qualifiers.caseSensitiveMatch && !qualifiers.exactNameMatch) {
                        sql.append("(UPPER(NAME) LIKE ?");
                        sql.addValue(text.endsWith("%") ? text.toUpperCase() : text.toUpperCase() + "%");
                    }
                    if (lang != null && lang.length() > 0) {
                        sql.append(" AND (UPPER(LANG_CODE) LIKE ?)");
                        sql.addValue(lang.toUpperCase() + "%");
                    }
                    sql.append(")");
                    if (i + 1 >= nameSize) continue;
                    sql.append(" OR ");
                }
            }
            sql.append(") ");
        }
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND S.SERVICE_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null || !qualifiers.sortByNameAsc && !qualifiers.sortByNameDesc && !qualifiers.sortByDateAsc && !qualifiers.sortByDateDesc) {
            sql.append("N.NAME ASC,S.LAST_UPDATE DESC");
        } else if (qualifiers.sortByNameAsc || qualifiers.sortByNameDesc) {
            if (qualifiers.sortByDateAsc || qualifiers.sortByDateDesc) {
                if (qualifiers.sortByNameAsc && qualifiers.sortByDateDesc) {
                    sql.append("N.NAME ASC,S.LAST_UPDATE DESC");
                } else if (qualifiers.sortByNameAsc && qualifiers.sortByDateAsc) {
                    sql.append("N.NAME ASC,S.LAST_UPDATE ASC");
                } else if (qualifiers.sortByNameDesc && qualifiers.sortByDateDesc) {
                    sql.append("N.NAME DESC,S.LAST_UPDATE DESC");
                } else {
                    sql.append("N.NAME DESC,S.LAST_UPDATE ASC");
                }
            } else if (qualifiers.sortByNameAsc) {
                sql.append("N.NAME ASC,S.LAST_UPDATE DESC");
            } else {
                sql.append("N.NAME DESC,S.LAST_UPDATE DESC");
            }
        } else if (qualifiers.sortByDateAsc || qualifiers.sortByDateDesc) {
            if (qualifiers.sortByDateDesc) {
                sql.append("S.LAST_UPDATE DESC,N.NAME ASC");
            } else {
                sql.append("S.LAST_UPDATE ASC,N.NAME ASC");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT S.SERVICE_KEY,S.LAST_UPDATE,N.NAME ");
        sql.append("FROM ").append(tablePrefix).append("BUSINESS_SERVICE S,").append(tablePrefix).append("SERVICE_NAME N ");
        selectSQL = sql.toString();
    }
}

