/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.BusinessKey;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.RelatedBusinessInfo;
import org.apache.juddi.datatype.response.RelatedBusinessInfos;
import org.apache.juddi.datatype.response.RelatedBusinessesList;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class RelatedBusinessesListHandler
extends AbstractHandler {
    public static final String TAG_NAME = "relatedBusinessList";
    private HandlerMaker maker = null;

    protected RelatedBusinessesListHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        RelatedBusinessesList obj = new RelatedBusinessesList();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        String truncValue = element.getAttribute("truncated");
        if (truncValue != null) {
            obj.setTruncated(truncValue.equalsIgnoreCase("true"));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "businessKey")).size() > 0) {
            handler = this.maker.lookup("businessKey");
            obj.setBusinessKey((BusinessKey)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "relatedBusinessInfos")).size() > 0) {
            handler = this.maker.lookup("relatedBusinessInfos");
            obj.setRelatedBusinessInfos((RelatedBusinessInfos)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        RelatedBusinessInfos infos;
        BusinessKey key;
        RelatedBusinessesList list = (RelatedBusinessesList)object;
        String generic = list.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        String operator = list.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        boolean truncated = list.isTruncated();
        if (truncated) {
            element.setAttribute("truncated", "true");
        }
        if ((key = list.getBusinessKey()) != null) {
            handler = this.maker.lookup("businessKey");
            handler.marshal(key, element);
        }
        if ((infos = list.getRelatedBusinessInfos()) != null) {
            handler = this.maker.lookup("relatedBusinessInfos");
            handler.marshal(infos, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        RelatedBusinessesList list = new RelatedBusinessesList();
        list.setGeneric("2.0");
        list.setOperator("jUDDI.org");
        list.setTruncated(true);
        list.setBusinessKey(new BusinessKey("f9f0c35f-06ab-4bec-9c7d-b1469e73f0eb"));
        list.addRelatedBusinessInfo(new RelatedBusinessInfo("abc"));
        list.addRelatedBusinessInfo(new RelatedBusinessInfo("xyz"));
        System.out.println();
        RegistryObject regObject = list;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

