/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.AddressingType;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.EndpointReference;
import javax.xml.ws.addressing.ReferenceParameters;
import javax.xml.ws.addressing.Relationship;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.AttributedURIImpl;
import org.jboss.ws.extensions.addressing.ElementExtensibleImpl;
import org.jboss.ws.extensions.addressing.ReferenceParametersImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressingPropertiesImpl
extends ElementExtensibleImpl
implements AddressingProperties {
    private static AddressingConstants ADDR = new AddressingConstantsImpl();
    private AttributedURI to;
    private AttributedURI action;
    private AttributedURI messageId;
    private Relationship[] relatesTo;
    private EndpointReference replyTo;
    private EndpointReference faultTo;
    private EndpointReference from;
    private ReferenceParameters refParams = new ReferenceParametersImpl();
    private Map<QName, AddressingType> addrTypes = new HashMap<QName, AddressingType>();
    private boolean initialized = false;

    @Override
    public AttributedURI getTo() {
        return this.to;
    }

    @Override
    public void setTo(AttributedURI to) {
        this.to = to;
    }

    @Override
    public AttributedURI getAction() {
        return this.action;
    }

    @Override
    public void setAction(AttributedURI action) {
        this.action = action;
    }

    @Override
    public AttributedURI getMessageID() {
        return this.messageId;
    }

    @Override
    public void setMessageID(AttributedURI iri) {
        this.messageId = iri;
    }

    @Override
    public Relationship[] getRelatesTo() {
        return this.relatesTo;
    }

    @Override
    public void setRelatesTo(Relationship[] relatesTo) {
        this.relatesTo = relatesTo;
    }

    @Override
    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setReplyTo(EndpointReference replyTo) {
        this.replyTo = replyTo;
    }

    @Override
    public EndpointReference getFaultTo() {
        return this.faultTo;
    }

    @Override
    public void setFaultTo(EndpointReference faultTo) {
        this.faultTo = faultTo;
    }

    @Override
    public EndpointReference getFrom() {
        return this.from;
    }

    @Override
    public void setFrom(EndpointReference from) {
        this.from = from;
    }

    @Override
    public ReferenceParameters getReferenceParameters() {
        return this.refParams;
    }

    @Override
    public void initializeAsDestination(EndpointReference epr) {
        if (this.initialized) {
            return;
        }
        if (epr == null) {
            throw new IllegalArgumentException("Invalid null endpoint reference");
        }
        this.to = epr.getAddress();
        ReferenceParameters srcParams = epr.getReferenceParameters();
        for (Object obj : srcParams.getElements()) {
            SOAPElement soapElement = (SOAPElement)obj;
            soapElement.setAttributeNS(this.getNamespaceURI(), "wsa:IsReferenceParameter", "true");
            this.addElement(soapElement.cloneNode(true));
        }
        this.initialized = true;
    }

    @Override
    public void initializeAsReply(AddressingProperties props, boolean isFault) {
        EndpointReference epr;
        if (this.initialized) {
            return;
        }
        EndpointReference endpointReference = epr = isFault ? props.getFaultTo() : null;
        if (epr == null) {
            epr = props.getReplyTo();
        }
        AttributedURI attributedURI = this.to = epr != null ? epr.getAddress() : new AttributedURIImpl(ADDR.getAnonymousURI());
        if (epr != null) {
            ReferenceParameters srcParams = epr.getReferenceParameters();
            for (Object obj : srcParams.getElements()) {
                SOAPElement soapElement = (SOAPElement)obj;
                soapElement.setAttributeNS(this.getNamespaceURI(), "wsa:IsReferenceParameter", "true");
                this.addElement(soapElement.cloneNode(true));
            }
        }
        if (props.getMessageID() != null) {
            AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
            Relationship rel = builder.newRelationship(props.getMessageID().getURI());
            this.relatesTo = new Relationship[]{rel};
        }
        this.initialized = true;
    }

    @Override
    public int size() {
        return this.addrTypes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.addrTypes.isEmpty();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.addrTypes.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.addrTypes.containsValue(arg0);
    }

    @Override
    public AddressingType get(Object arg0) {
        return this.addrTypes.get(arg0);
    }

    @Override
    public AddressingType put(QName arg0, AddressingType arg1) {
        return this.addrTypes.put(arg0, arg1);
    }

    @Override
    public AddressingType remove(Object arg0) {
        return this.addrTypes.remove(arg0);
    }

    @Override
    public void putAll(Map<? extends QName, ? extends AddressingType> arg0) {
        this.addrTypes.putAll(arg0);
    }

    @Override
    public void clear() {
        this.addrTypes.clear();
    }

    @Override
    public Set<QName> keySet() {
        return this.addrTypes.keySet();
    }

    @Override
    public Collection<AddressingType> values() {
        return this.addrTypes.values();
    }

    @Override
    public Set<Map.Entry<QName, AddressingType>> entrySet() {
        return this.addrTypes.entrySet();
    }
}

