/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.CodeBuffer;
import org.apache.bsf.util.IOUtils;

public class Main {
    private static String ARG_IN = "-in";
    private static String ARG_LANG = "-lang";
    private static String ARG_MODE = "-mode";
    private static String ARG_OUT = "-out";
    private static String ARG_VAL_EVAL = "eval";
    private static String ARG_VAL_EXEC = "exec";
    private static String ARG_VAL_COMPILE = "compile";
    private static String DEFAULT_IN_FILE_NAME = "<STDIN>";
    private static String DEFAULT_MODE = ARG_VAL_EVAL;
    private static String DEFAULT_CLASS_NAME = "Test";

    public static void main(String[] args) throws IOException {
        try {
            InputStreamReader in;
            if (args.length == 0 || args.length % 2 != 0) {
                Main.printHelp();
                System.exit(1);
            }
            Hashtable<String, String> argsTable = new Hashtable<String, String>();
            argsTable.put(ARG_OUT, DEFAULT_CLASS_NAME);
            argsTable.put(ARG_MODE, DEFAULT_MODE);
            for (int i = 0; i < args.length; i += 2) {
                argsTable.put(args[i], args[i + 1]);
            }
            String inFileName = (String)argsTable.get(ARG_IN);
            String language = (String)argsTable.get(ARG_LANG);
            if (language == null) {
                if (inFileName != null) {
                    language = BSFManager.getLangFromFilename(inFileName);
                } else {
                    throw new BSFException(500, "unable to determine language");
                }
            }
            if (inFileName != null) {
                in = new FileReader(inFileName);
            } else {
                in = new InputStreamReader(System.in);
                inFileName = DEFAULT_IN_FILE_NAME;
            }
            BSFManager mgr = new BSFManager();
            String mode = (String)argsTable.get(ARG_MODE);
            if (mode.equals(ARG_VAL_COMPILE)) {
                String outClassName = (String)argsTable.get(ARG_OUT);
                FileWriter out = new FileWriter(outClassName + ".java");
                PrintWriter pw = new PrintWriter(out);
                CodeBuffer cb = new CodeBuffer();
                cb.setClassName(outClassName);
                mgr.compileScript(language, inFileName, 0, 0, IOUtils.getStringFromReader(in), cb);
                cb.print(pw, true);
                out.close();
            } else if (mode.equals(ARG_VAL_EXEC)) {
                mgr.exec(language, inFileName, 0, 0, IOUtils.getStringFromReader(in));
            } else {
                Object obj = mgr.eval(language, inFileName, 0, 0, IOUtils.getStringFromReader(in));
                if (obj instanceof Component) {
                    Frame f;
                    if (obj instanceof Frame) {
                        f = (Frame)obj;
                    } else {
                        f = new Frame("BSF Result: " + inFileName);
                        f.add((Component)obj);
                    }
                    f.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                    f.pack();
                    f.setVisible(true);
                } else {
                    System.err.println("Result: " + obj);
                }
                System.err.println("Result: " + obj);
            }
        }
        catch (BSFException e) {
            e.printStackTrace();
        }
    }

    private static void printHelp() {
        System.err.println("Usage:");
        System.err.println();
        System.err.println("  java " + Main.class.getName() + " [args]");
        System.err.println();
        System.err.println("    args:");
        System.err.println();
        System.err.println("      [-in                fileName]   default: " + DEFAULT_IN_FILE_NAME);
        System.err.println("      [-lang          languageName]   default: <If -in is specified and -lang");
        System.err.println("                                                is not, attempt to determine");
        System.err.println("                                                language from file extension;");
        System.err.println("                                                otherwise, -lang is required.>");
        System.err.println("      [-mode   (eval|exec|compile)]   default: " + DEFAULT_MODE);
        System.err.println();
        System.err.println("    Additional args used only if -mode is set to \"compile\":");
        System.err.println();
        System.err.println("      [-out              className]   default: " + DEFAULT_CLASS_NAME);
    }
}

