/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyConfigurator
implements Configurator {
    private static final String[] EMPTY_STRINGS = new String[0];
    private Map<String, Handler> configuredHandlers;
    private Map<String, Filter> configuredFilters;
    private Map<String, Formatter> configuredFormatters;
    private Map<String, ErrorManager> configuredErrorManagers;
    private Map<String, Logger> configuredLoggers;
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int DEFAULT = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(InputStream inputStream) throws IOException {
        this.configuredHandlers = new HashMap<String, Handler>();
        this.configuredFilters = new HashMap<String, Filter>();
        this.configuredFormatters = new HashMap<String, Formatter>();
        this.configuredErrorManagers = new HashMap<String, ErrorManager>();
        this.configuredLoggers = new HashMap<String, Logger>();
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        finally {
            PropertyConfigurator.safeClose(inputStream);
        }
        this.configure(properties);
    }

    private void configure(Properties properties) throws IOException {
        List<String> loggerNames = PropertyConfigurator.getStringCsvList(properties, "loggers", "");
        HashSet<String> done = new HashSet<String>();
        for (String loggerName : loggerNames) {
            String filterName;
            if (!done.add(loggerName)) continue;
            Logger logger = LogContext.getSystemLogContext().getLogger(loggerName);
            this.configuredLoggers.put(loggerName, logger);
            String levelName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "level"));
            if (levelName != null) {
                logger.setLevel(LogContext.getSystemLogContext().getLevelForName(levelName));
            }
            if ((filterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "filter"))) != null) {
                logger.setFilter(this.configureFilter(properties, filterName));
            }
            List<String> handlerNames = PropertyConfigurator.getStringCsvList(properties, PropertyConfigurator.getKey("logger", loggerName, "handlers"));
            for (String handlerName : handlerNames) {
                logger.addHandler(this.configureHandler(properties, handlerName));
            }
            String useParentHandlersString = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "useParentHandlers"));
            if (useParentHandlersString == null) continue;
            logger.setUseParentHandlers(Boolean.parseBoolean(useParentHandlersString));
        }
    }

    private void configureProperties(Properties properties, Object object, String prefix) throws IOException {
        List<String> propertyNames = PropertyConfigurator.getStringCsvList(properties, PropertyConfigurator.getKey(prefix, "properties"));
        Class<?> objClass = object.getClass();
        Iterator<String> it = propertyNames.iterator();
        if (!it.hasNext()) {
            return;
        }
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : objClass.getMethods()) {
            Class<?>[] parameterTypes;
            String name;
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !(name = method.getName()).startsWith("set") || (parameterTypes = method.getParameterTypes()).length != 1 || method.getReturnType() != Void.TYPE) continue;
            setters.put(name.substring(3, 4).toLowerCase() + name.substring(4), method);
        }
        do {
            String propertyName;
            String propValue;
            Method method;
            if ((propValue = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey(prefix, propertyName = it.next()))) == null) continue;
            method = (Method)setters.get(propertyName);
            if (method == null) {
                throw new IllegalArgumentException("Declared property " + propertyName + " wasn't found on " + objClass);
            }
            Object argument = this.getArgument(properties, method, propertyName, propValue);
            try {
                method.invoke(object, argument);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to set property " + propertyName + " on " + objClass, e);
            }
        } while (it.hasNext());
    }

    private Object getArgument(Properties properties, Method method, String propertyName, String propValue) throws IOException {
        Object argument;
        Class<?> objClass = method.getDeclaringClass();
        Class<?> paramType = method.getParameterTypes()[0];
        if (paramType == String.class) {
            argument = propValue;
        } else if (paramType == Handler.class) {
            argument = this.configureHandler(properties, propValue);
        } else if (paramType == Filter.class) {
            argument = this.configureFilter(properties, propValue);
        } else if (paramType == Formatter.class) {
            argument = this.configureFormatter(properties, propValue);
        } else if (paramType == Level.class) {
            argument = LogContext.getSystemLogContext().getLevelForName(propValue);
        } else if (paramType == java.util.logging.Logger.class) {
            argument = LogContext.getSystemLogContext().getLogger(propValue);
        } else if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            argument = Boolean.valueOf(propValue);
        } else if (paramType == Byte.TYPE || paramType == Byte.class) {
            argument = Byte.valueOf(propValue);
        } else if (paramType == Short.TYPE || paramType == Short.class) {
            argument = Short.valueOf(propValue);
        } else if (paramType == Integer.TYPE || paramType == Integer.class) {
            argument = Integer.valueOf(propValue);
        } else if (paramType == Long.TYPE || paramType == Long.class) {
            argument = Long.valueOf(propValue);
        } else if (paramType == Float.TYPE || paramType == Float.class) {
            argument = Float.valueOf(propValue);
        } else if (paramType == Double.TYPE || paramType == Double.class) {
            argument = Double.valueOf(propValue);
        } else if (paramType == Character.TYPE || paramType == Character.class) {
            argument = Character.valueOf(propValue.length() > 0 ? propValue.charAt(0) : (char)'\u0000');
        } else if (paramType == TimeZone.class) {
            argument = TimeZone.getTimeZone(propValue);
        } else if (paramType == Charset.class) {
            argument = Charset.forName(propValue);
        } else {
            throw new IllegalArgumentException("Unknown paramter type for property " + propertyName + " on " + objClass);
        }
        return argument;
    }

    private Handler configureHandler(Properties properties, String handlerName) throws IOException {
        String formatterName;
        String filterName;
        String errorManagerName;
        String encodingName;
        Handler handler;
        if (this.configuredHandlers.containsKey(handlerName)) {
            return this.configuredHandlers.get(handlerName);
        }
        String handlerClassName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName));
        if (handlerClassName == null) {
            throw new IllegalArgumentException("Handler " + handlerName + " has no class name");
        }
        try {
            handler = (Handler)Class.forName(handlerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Handler " + handlerName + " could not be instantiated", e);
        }
        this.configuredHandlers.put(handlerName, handler);
        String levelName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "level"));
        if (levelName != null) {
            handler.setLevel(LogContext.getSystemLogContext().getLevelForName(levelName));
        }
        if ((encodingName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "encoding"))) != null) {
            handler.setEncoding(encodingName);
        }
        if ((errorManagerName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "errorManager"))) != null) {
            handler.setErrorManager(this.configureErrorManager(properties, errorManagerName));
        }
        if ((filterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "filter"))) != null) {
            handler.setFilter(this.configureFilter(properties, filterName));
        }
        if ((formatterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "formatter"))) != null) {
            handler.setFormatter(this.configureFormatter(properties, formatterName));
        }
        this.configureProperties(properties, handler, PropertyConfigurator.getKey("handler", handlerName));
        return handler;
    }

    private ErrorManager configureErrorManager(Properties properties, String errorManagerName) throws IOException {
        ErrorManager errorManager;
        if (this.configuredErrorManagers.containsKey(errorManagerName)) {
            return this.configuredErrorManagers.get(errorManagerName);
        }
        String errorManagerClassName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("errorManager", errorManagerName));
        if (errorManagerClassName == null) {
            throw new IllegalArgumentException("Error manager " + errorManagerName + " has no class name");
        }
        try {
            errorManager = (ErrorManager)Class.forName(errorManagerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error manager " + errorManagerName + " could not be instantiated", e);
        }
        this.configuredErrorManagers.put(errorManagerName, errorManager);
        this.configureProperties(properties, errorManager, PropertyConfigurator.getKey("errorManager", errorManagerName));
        return errorManager;
    }

    private Formatter configureFormatter(Properties properties, String formatterName) throws IOException {
        Formatter formatter;
        if (this.configuredFormatters.containsKey(formatterName)) {
            return this.configuredFormatters.get(formatterName);
        }
        String formatterClassName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("formatter", formatterName));
        if (formatterClassName == null) {
            throw new IllegalArgumentException("Formatter " + formatterName + " has no class name");
        }
        try {
            formatter = (Formatter)Class.forName(formatterClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Formatter " + formatterName + " could not be instantiated", e);
        }
        this.configuredFormatters.put(formatterName, formatter);
        this.configureProperties(properties, formatter, PropertyConfigurator.getKey("formatter", formatterName));
        return formatter;
    }

    private Filter configureFilter(Properties properties, String filterName) throws IOException {
        Filter filter;
        if (this.configuredFilters.containsKey(filterName)) {
            return this.configuredFilters.get(filterName);
        }
        String filterClassName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", filterName));
        if (filterClassName == null) {
            throw new IllegalArgumentException("Filter " + filterName + " has no class name");
        }
        try {
            filter = (Filter)Class.forName(filterClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter " + filterName + " could not be instantiated", e);
        }
        this.configuredFilters.put(filterName, filter);
        this.configureProperties(properties, filter, PropertyConfigurator.getKey("filter", filterName));
        return filter;
    }

    private static String getKey(String prefix, String objectName) {
        return objectName.length() > 0 ? prefix + "." + objectName : prefix;
    }

    private static String getKey(String prefix, String objectName, String key) {
        return objectName.length() > 0 ? prefix + "." + objectName + "." + key : prefix + "." + key;
    }

    private static String getStringProperty(Properties properties, String key) {
        String val = properties.getProperty(key);
        return val == null ? null : PropertyConfigurator.replaceProperties(val);
    }

    private static String[] getStringCsvArray(Properties properties, String key) {
        String value = properties.getProperty(key, "").trim();
        if (value.length() == 0) {
            return EMPTY_STRINGS;
        }
        String realValue = PropertyConfigurator.replaceProperties(value);
        return realValue.split("\\s*,\\s*");
    }

    private static List<String> getStringCsvList(Properties properties, String key) {
        return new ArrayList<String>(Arrays.asList(PropertyConfigurator.getStringCsvArray(properties, key)));
    }

    private static List<String> getStringCsvList(Properties properties, String key, String ... prepend) {
        String[] array = PropertyConfigurator.getStringCsvArray(properties, key);
        ArrayList<String> list = new ArrayList<String>(array.length + prepend.length);
        list.addAll(Arrays.asList(prepend));
        list.addAll(Arrays.asList(array));
        return list;
    }

    private static void safeClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String replaceProperties(String value) {
        StringBuilder builder = new StringBuilder();
        char[] chars = value.toCharArray();
        int len = chars.length;
        int state = 0;
        int start = -1;
        int nameStart = -1;
        block21: for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            switch (state) {
                case 0: {
                    switch (ch) {
                        case '$': {
                            state = 1;
                            continue block21;
                        }
                    }
                    builder.append(ch);
                    continue block21;
                }
                case 1: {
                    switch (ch) {
                        case '$': {
                            builder.append(ch);
                            state = 0;
                            continue block21;
                        }
                        case '{': {
                            nameStart = start = i + 1;
                            state = 2;
                            continue block21;
                        }
                    }
                    builder.append('$').append(ch);
                    state = 0;
                    continue block21;
                }
                case 2: {
                    switch (ch) {
                        case ',': 
                        case ':': 
                        case '}': {
                            String name = value.substring(nameStart, i).trim();
                            if ("/".equals(name)) {
                                builder.append(File.separator);
                                state = ch == '}' ? 0 : 3;
                                continue block21;
                            }
                            if (":".equals(name)) {
                                builder.append(File.pathSeparator);
                                state = ch == '}' ? 0 : 3;
                                continue block21;
                            }
                            String val = System.getProperty(name);
                            if (val != null) {
                                builder.append(val);
                                state = ch == '}' ? 0 : 3;
                                continue block21;
                            }
                            if (ch == ',') {
                                nameStart = i + 1;
                                continue block21;
                            }
                            if (ch == ':') {
                                start = i + 1;
                                state = 4;
                                continue block21;
                            }
                            builder.append(value.substring(start - 2, i + 1));
                            state = 0;
                            continue block21;
                        }
                    }
                    continue block21;
                }
                case 3: {
                    if (ch != '}') continue block21;
                    state = 0;
                    continue block21;
                }
                case 4: {
                    if (ch != '}') continue block21;
                    state = 0;
                    builder.append(value.substring(start, i));
                    continue block21;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        switch (state) {
            case 1: {
                builder.append('$');
                break;
            }
            case 2: 
            case 4: {
                builder.append(value.substring(start - 2));
            }
        }
        return builder.toString();
    }
}

