/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.concurrent.locks.ReentrantLock;
import org.jboss.seam.Component;
import org.jboss.seam.CyclicDependencyException;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.util.Exceptions;

@Interceptor
public class BijectionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 4686458105931528659L;
    private boolean injected;
    private boolean injecting;
    private int clients = 0;
    private ReentrantLock lock = new ReentrantLock();

    public void setComponent(Component component) {
        super.setComponent(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Component component = this.getComponent();
        boolean enforceRequired = !component.isLifecycleMethod(invocation.getMethod());
        try {
            Object result;
            block31: {
                this.lock.lock();
                try {
                    if (!this.injected) {
                        if (this.injecting) {
                            throw new CyclicDependencyException();
                        }
                        this.injecting = true;
                        try {
                            component.inject(invocation.getTarget(), enforceRequired);
                        }
                        finally {
                            this.injecting = false;
                        }
                        this.injected = true;
                    }
                    ++this.clients;
                }
                finally {
                    this.lock.unlock();
                }
                result = invocation.proceed();
                this.lock.lock();
                try {
                    if (this.clients != 1) break block31;
                    try {
                        component.outject(invocation.getTarget(), enforceRequired);
                    }
                    finally {
                        if (this.injected) {
                            this.injected = false;
                            --this.clients;
                            component.disinject(invocation.getTarget());
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            Exception root = e;
            while (Exceptions.getCause(root) != null) {
                root = Exceptions.getCause(root);
            }
            if (root instanceof CyclicDependencyException) {
                CyclicDependencyException cyclicDependencyException = (CyclicDependencyException)root;
                cyclicDependencyException.addInvocation(this.getComponent().getName(), invocation.getMethod());
            }
            throw e;
        }
        finally {
            if (this.injected) {
                this.lock.lock();
                try {
                    --this.clients;
                    if (this.clients == 0) {
                        this.injected = false;
                        component.disinject(invocation.getTarget());
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().needsInjection() || this.getComponent().needsOutjection();
    }
}

