/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.remoting;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.profileservice.remoting.PojiMethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContainer
implements InvocationHandler {
    private static ThreadLocal<Invocation> activeInvocation = new ThreadLocal();
    private List<Interceptor> interceptors;
    private Object target;

    SecurityContainer(List<Interceptor> interceptors, Object target) {
        this.interceptors = interceptors;
        this.target = target;
    }

    public static void setInvocation(Invocation inv) {
        activeInvocation.set(inv);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object inv = activeInvocation.get();
        if (inv instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)inv;
            mi.setTargetObject(this.target);
            inv = new PojiMethodInvocation(mi, method);
        }
        for (Interceptor i : this.interceptors) {
            i.invoke(inv);
        }
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }
}

