/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.navtree;

import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeAction;
import org.jboss.console.manager.interfaces.TreeInfo;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.navtree.NodeWrapper;

public class StdNodeWrapper
implements NodeWrapper {
    TreeNode node = null;
    NodeWrapper[] sons = null;
    TreeNode[] realSons = null;
    TreeInfo master = null;
    String path = null;

    public StdNodeWrapper(TreeNode node, TreeInfo master, String parentPath) {
        int i;
        this.node = node;
        this.master = master;
        this.path = parentPath + "/" + this.node.getName();
        TreeNode[] plugged = null;
        if (node instanceof ResourceTreeNode) {
            plugged = master.getTreesForResource(((ResourceTreeNode)node).getResource());
            int visibility = ((ResourceTreeNode)node).getVisibility();
            if (visibility == 2 && plugged != null && plugged.length > 0) {
                this.node = this.getMasterFromPluggins(plugged);
                plugged = this.removeMasterFromList(plugged, this.node);
            }
        }
        TreeNode[] res = this.node.getNodeManagableResources();
        TreeNode[] sub = this.node.getSubNodes();
        if (res == null) {
            res = new TreeNode[]{};
        }
        if (sub == null) {
            sub = new TreeNode[]{};
        }
        if (plugged == null) {
            plugged = new TreeNode[]{};
        }
        this.realSons = new TreeNode[res.length + sub.length + plugged.length];
        this.sons = new NodeWrapper[res.length + sub.length + plugged.length];
        for (i = 0; i < res.length; ++i) {
            this.realSons[i] = res[i];
        }
        for (i = 0; i < sub.length; ++i) {
            this.realSons[res.length + i] = sub[i];
        }
        for (i = 0; i < plugged.length; ++i) {
            this.realSons[res.length + sub.length + i] = plugged[i];
        }
    }

    public Object getChild(int index) {
        if (index >= this.sons.length) {
            return null;
        }
        if (this.sons[index] == null) {
            this.sons[index] = new StdNodeWrapper(this.realSons[index], this.master, this.path);
        }
        return this.sons[index];
    }

    public int getChildCount() {
        return this.realSons.length;
    }

    public int getIndexOfChild(Object child) {
        for (int i = 0; i < this.sons.length; ++i) {
            if (this.sons[i] != child) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf() {
        return this.sons.length == 0;
    }

    public String toString() {
        return this.node.getName();
    }

    public String getIconUrl() {
        return this.node.getIcon();
    }

    public TreeAction getAssociatedAction() {
        return this.node.getAction();
    }

    public String getDescription() {
        return this.node.getDescription();
    }

    public TreeNodeMenuEntry[] getMenuEntries() {
        return this.node.getMenuEntries();
    }

    public String getPath() {
        return this.path;
    }

    protected TreeNode getMasterFromPluggins(TreeNode[] plugged) {
        for (int i = 0; i < plugged.length; ++i) {
            if (!plugged[i].isMasterNode()) continue;
            return plugged[i];
        }
        return plugged[0];
    }

    protected TreeNode[] removeMasterFromList(TreeNode[] all, TreeNode main) {
        TreeNode[] result = new TreeNode[all.length - 1];
        int cursor = 0;
        for (int i = 0; i < all.length; ++i) {
            if (all[i] == main) continue;
            result[cursor] = all[i];
            ++cursor;
        }
        return result;
    }
}

