/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyStartupListener
implements HttpSessionListener,
ServletRequestListener,
ServletContextListener,
HttpSessionAttributeListener,
ServletRequestAttributeListener,
ServletContextAttributeListener {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConcurrentLinkedQueue<ContextEvent> contextEvents = new ConcurrentLinkedQueue();
    private volatile ArrayList<HttpSessionListener> sessionListeners;
    private volatile ArrayList<HttpSessionAttributeListener> sessionAttributeListeners;
    private volatile ArrayList<ServletRequestListener> requestListeners;
    private volatile ArrayList<ServletRequestAttributeListener> requestAttributeListeners;
    private volatile ArrayList<ServletContextListener> contextListeners;
    private volatile ArrayList<ServletContextAttributeListener> contextAttributeListeners;
    private volatile boolean initialized = false;
    private volatile ServletContext context;
    private volatile String[] names;
    private final ReentrantReadWriteLock replayLock = new ReentrantReadWriteLock();

    private void setupListeners() {
        ArrayList<HttpSessionListener> sessionListeners = new ArrayList<HttpSessionListener>();
        ArrayList<HttpSessionAttributeListener> sessionAttributeListeners = new ArrayList<HttpSessionAttributeListener>();
        ArrayList<ServletRequestListener> requestListeners = new ArrayList<ServletRequestListener>();
        ArrayList<ServletRequestAttributeListener> requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
        ArrayList<ServletContextListener> contextListeners = new ArrayList<ServletContextListener>();
        ArrayList<ServletContextAttributeListener> contextAttributeListeners = new ArrayList<ServletContextAttributeListener>();
        Object[] objs = new Object[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            try {
                objs[i] = Class.forName(this.names[i]).newInstance();
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Could not find/load listener: " + this.names[i]), (Throwable)e);
            }
        }
        for (Object obj : objs) {
            if (obj instanceof HttpSessionListener) {
                sessionListeners.add((HttpSessionListener)obj);
            }
            if (obj instanceof HttpSessionAttributeListener) {
                sessionAttributeListeners.add((HttpSessionAttributeListener)obj);
            }
            if (obj instanceof ServletRequestListener) {
                requestListeners.add((ServletRequestListener)obj);
            }
            if (obj instanceof ServletRequestAttributeListener) {
                requestAttributeListeners.add((ServletRequestAttributeListener)obj);
            }
            if (obj instanceof ServletContextListener) {
                contextListeners.add((ServletContextListener)obj);
            }
            if (obj instanceof ServletContextAttributeListener) {
                contextAttributeListeners.add((ServletContextAttributeListener)obj);
            }
            this.log.debug((Object)("Activated listener: " + obj));
        }
        this.sessionListeners = sessionListeners;
        this.sessionAttributeListeners = sessionAttributeListeners;
        this.requestListeners = requestListeners;
        this.requestAttributeListeners = requestAttributeListeners;
        this.contextListeners = contextListeners;
        this.contextAttributeListeners = contextAttributeListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.log.debug((Object)"Activating listeners");
        this.setupListeners();
        try {
            this.replayLock.writeLock().lock();
            ConcurrentLinkedQueue<ContextEvent> events = this.contextEvents;
            ContextEvent event = events.poll();
            while (event != null) {
                switch (event.type) {
                    case INIT: {
                        for (ServletContextListener servletContextListener : this.contextListeners) {
                            servletContextListener.contextInitialized(event.event);
                        }
                        break;
                    }
                    case ADD: {
                        for (ServletContextAttributeListener servletContextAttributeListener : this.contextAttributeListeners) {
                            servletContextAttributeListener.attributeAdded((ServletContextAttributeEvent)event.event);
                        }
                        break;
                    }
                    case REMOVE: {
                        for (ServletContextAttributeListener servletContextAttributeListener : this.contextAttributeListeners) {
                            servletContextAttributeListener.attributeRemoved((ServletContextAttributeEvent)event.event);
                        }
                        break;
                    }
                    case REPLACE: {
                        for (ServletContextAttributeListener servletContextAttributeListener : this.contextAttributeListeners) {
                            servletContextAttributeListener.attributeReplaced((ServletContextAttributeEvent)event.event);
                        }
                        break;
                    }
                }
                event = events.poll();
            }
            this.initialized = true;
        }
        finally {
            this.replayLock.writeLock().unlock();
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.initialize();
        ArrayList<HttpSessionListener> listeners = this.sessionListeners;
        for (HttpSessionListener listener : listeners) {
            listener.sessionCreated(event);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.initialize();
        ArrayList<HttpSessionListener> listeners = this.sessionListeners;
        for (HttpSessionListener listener : listeners) {
            listener.sessionDestroyed(event);
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
        this.initialize();
        ArrayList<ServletRequestListener> listeners = this.requestListeners;
        for (ServletRequestListener listener : listeners) {
            listener.requestDestroyed(event);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        this.initialize();
        ArrayList<ServletRequestListener> listeners = this.requestListeners;
        for (ServletRequestListener listener : listeners) {
            listener.requestInitialized(event);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (!this.initialized) {
            this.contextEvents.clear();
            return;
        }
        this.initialize();
        ArrayList<ServletContextListener> listeners = this.contextListeners;
        for (ServletContextListener listener : listeners) {
            listener.contextDestroyed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        this.context = event.getServletContext();
        String param = this.context.getInitParameter(this.getClass().getName());
        this.log.debug((Object)("Listeners configured for lazy loading: " + param));
        this.names = param == null ? new String[]{} : param.split(",");
        try {
            this.replayLock.readLock().lock();
            if (!this.initialized) {
                this.contextEvents.add(new ContextEvent(ContextEventType.INIT, event));
                return;
            }
            ArrayList<ServletContextListener> listeners = this.contextListeners;
            for (ServletContextListener listener : listeners) {
                listener.contextInitialized(event);
            }
        }
        finally {
            this.replayLock.readLock().unlock();
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        this.initialize();
        ArrayList<HttpSessionAttributeListener> listeners = this.sessionAttributeListeners;
        for (HttpSessionAttributeListener listener : listeners) {
            listener.attributeAdded(event);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this.initialize();
        ArrayList<HttpSessionAttributeListener> listeners = this.sessionAttributeListeners;
        for (HttpSessionAttributeListener listener : listeners) {
            listener.attributeRemoved(event);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.initialize();
        ArrayList<HttpSessionAttributeListener> listeners = this.sessionAttributeListeners;
        for (HttpSessionAttributeListener listener : listeners) {
            listener.attributeReplaced(event);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
        this.initialize();
        ArrayList<ServletRequestAttributeListener> listeners = this.requestAttributeListeners;
        for (ServletRequestAttributeListener listener : listeners) {
            listener.attributeAdded(event);
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        this.initialize();
        ArrayList<ServletRequestAttributeListener> listeners = this.requestAttributeListeners;
        for (ServletRequestAttributeListener listener : listeners) {
            listener.attributeRemoved(event);
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        this.initialize();
        ArrayList<ServletRequestAttributeListener> listeners = this.requestAttributeListeners;
        for (ServletRequestAttributeListener listener : listeners) {
            listener.attributeReplaced(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeAdded(ServletContextAttributeEvent event) {
        try {
            this.replayLock.readLock().lock();
            if (!this.initialized) {
                this.contextEvents.add(new ContextEvent(ContextEventType.ADD, (ServletContextEvent)event));
                return;
            }
            ArrayList<ServletContextAttributeListener> listeners = this.contextAttributeListeners;
            for (ServletContextAttributeListener listener : listeners) {
                listener.attributeAdded(event);
            }
        }
        finally {
            this.replayLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeRemoved(ServletContextAttributeEvent event) {
        try {
            this.replayLock.readLock().lock();
            if (!this.initialized) {
                this.contextEvents.add(new ContextEvent(ContextEventType.REMOVE, (ServletContextEvent)event));
                return;
            }
            ArrayList<ServletContextAttributeListener> listeners = this.contextAttributeListeners;
            for (ServletContextAttributeListener listener : listeners) {
                listener.attributeRemoved(event);
            }
        }
        finally {
            this.replayLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeReplaced(ServletContextAttributeEvent event) {
        try {
            this.replayLock.readLock().lock();
            if (!this.initialized) {
                this.contextEvents.add(new ContextEvent(ContextEventType.REPLACE, (ServletContextEvent)event));
                return;
            }
            ArrayList<ServletContextAttributeListener> listeners = this.contextAttributeListeners;
            for (ServletContextAttributeListener listener : listeners) {
                listener.attributeRemoved(event);
            }
        }
        finally {
            this.replayLock.readLock().unlock();
        }
    }

    private final class ContextEvent {
        final ContextEventType type;
        final ServletContextEvent event;

        private ContextEvent(ContextEventType type, ServletContextEvent event) {
            this.type = type;
            this.event = event;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContextEventType {
        ADD,
        REMOVE,
        REPLACE,
        INIT;

    }
}

