/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.system.ServiceController;
import org.jboss.system.microcontainer.ServiceControllerContext;

public class LifecycleInfo {
    private ServiceControllerContext context;
    private Map<String, StateInfo> lifecycleOps;

    public LifecycleInfo(ServiceControllerContext context) throws Throwable {
        MBeanInfo info;
        MBeanOperationInfo[] ops;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.context = context;
        this.lifecycleOps = new HashMap<String, StateInfo>();
        this.lifecycleOps.put("create", new StateInfo(false, true, ControllerState.CREATE));
        this.lifecycleOps.put("start", new StateInfo(false, true, ControllerState.INSTALLED));
        this.lifecycleOps.put("stop", new StateInfo(false, false, ControllerState.CREATE));
        this.lifecycleOps.put("destroy", new StateInfo(false, false, ControllerState.CONFIGURED));
        ServiceController controller = context.getServiceController();
        MBeanServer server = controller.getMBeanServer();
        if (server != null && (ops = (info = server.getMBeanInfo(context.getObjectName())).getOperations()) != null) {
            for (MBeanOperationInfo op : ops) {
                String name = op.getName();
                StateInfo flag = this.lifecycleOps.get(name);
                if (flag == null || !op.getReturnType().equals("void") || op.getSignature().length != 0) continue;
                flag.opExists = true;
            }
        }
    }

    public ControllerState lifecycleInvocation(String opName, String[] signature) throws Throwable {
        if (signature != null && signature.length > 0) {
            return null;
        }
        StateInfo flag = this.lifecycleOps.get(opName);
        if (flag == null || !flag.opExists) {
            return null;
        }
        Controller controller = this.context.getController();
        ControllerStateModel model = controller.getStates();
        ControllerState state = this.context.getState();
        if (flag.installPhase) {
            if (model.isAfterState(flag.state, state)) {
                return flag.state;
            }
            return state;
        }
        if (model.isBeforeState(flag.state, state)) {
            return flag.state;
        }
        return state;
    }

    private class StateInfo {
        boolean opExists;
        boolean installPhase;
        ControllerState state;

        private StateInfo(boolean opExists, boolean installPhase, ControllerState state) {
            this.opExists = opExists;
            this.installPhase = installPhase;
            this.state = state;
        }
    }
}

