/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.logging.Logger;

public final class JDBCStartCommand {
    private static final String IDX_POSTFIX = "_idx";
    private static final String COULDNT_SUSPEND = "Could not suspend current transaction before ";
    private static final String COULDNT_REATTACH = "Could not reattach original transaction after ";
    private static final Object CREATED_TABLES_KEY = new Object();
    private final JDBCEntityPersistenceStore manager;
    private final JDBCAbstractEntityBridge entity;
    private final JDBCEntityMetaData entityMetaData;
    private final Logger log;
    private int idxCount = 0;

    public JDBCStartCommand(JDBCEntityPersistenceStore manager) {
        this.manager = manager;
        this.entity = manager.getEntityBridge();
        this.entityMetaData = manager.getMetaData();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
        this.idxCount = 1;
        Set tables = (Set)manager.getApplicationData(CREATED_TABLES_KEY);
        if (tables == null) {
            manager.putApplicationData(CREATED_TABLES_KEY, new HashSet());
        }
    }

    public void execute() throws DeploymentException {
        Set existedTables = JDBCStartCommand.getExistedTables(this.manager);
        boolean tableExisted = SQLUtil.tableExists(this.entity.getQualifiedTableName(), this.entity.getDataSource());
        if (tableExisted) {
            existedTables.add(this.entity.getEntityName());
        }
        if (tableExisted && this.entityMetaData.getAlterTable()) {
            SQLUtil.OldColumns oldColumns = SQLUtil.getOldColumns(this.entity.getQualifiedTableName(), this.entity.getDataSource());
            ArrayList oldNames = oldColumns.getColumnNames();
            ArrayList oldTypes = oldColumns.getTypeNames();
            ArrayList oldSizes = oldColumns.getColumnSizes();
            SQLUtil.OldIndexes oldIndexes = null;
            ArrayList<String> newNames = new ArrayList<String>();
            JDBCFieldBridge[] fields = this.entity.getTableFields();
            String tableName = this.entity.getQualifiedTableName();
            for (int i = 0; i < fields.length; ++i) {
                JDBCFieldBridge field = fields[i];
                JDBCType jdbcType = field.getJDBCType();
                String[] columnNames = jdbcType.getColumnNames();
                String[] sqlTypes = jdbcType.getSQLTypes();
                boolean[] notNull = jdbcType.getNotNull();
                for (int j = 0; j < columnNames.length; ++j) {
                    String name = columnNames[j];
                    String ucName = name.toUpperCase();
                    newNames.add(ucName);
                    int oldIndex = oldNames.indexOf(ucName);
                    if (oldIndex == -1) {
                        StringBuffer buf = new StringBuffer(sqlTypes[j]);
                        if (notNull[j]) {
                            buf.append(" NOT ").append("NULL");
                        }
                        this.alterTable(this.entity.getDataSource(), this.entityMetaData.getTypeMapping().getAddColumnTemplate(), tableName, name, buf.toString());
                        continue;
                    }
                    String type = (String)oldTypes.get(oldIndex);
                    if (!type.equals("CHAR") && !type.equals("VARCHAR")) continue;
                    try {
                        String l = sqlTypes[j];
                        l = l.substring(l.indexOf(40) + 1, l.length() - 1);
                        Integer oldLength = (Integer)oldSizes.get(oldIndex);
                        if (Integer.parseInt(l) <= oldLength) continue;
                        this.alterTable(this.entity.getDataSource(), this.entityMetaData.getTypeMapping().getAlterColumnTemplate(), tableName, name, sqlTypes[j]);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("EXCEPTION ALTER :" + e.toString()));
                    }
                }
                JDBCCMPFieldMetaData fieldMD = this.entity.getMetaData().getCMPFieldByName(field.getFieldName());
                if (fieldMD == null || !fieldMD.isIndexed()) continue;
                if (oldIndexes == null) {
                    oldIndexes = SQLUtil.getOldIndexes(this.entity.getQualifiedTableName(), this.entity.getDataSource());
                    this.idxCount = oldIndexes.getIndexNames().size();
                }
                if (this.hasIndex(oldIndexes, field)) continue;
                this.createCMPIndex(this.entity.getDataSource(), field, oldIndexes.getIndexNames());
            }
            for (String name : oldNames) {
                if (newNames.contains(name)) continue;
                this.alterTable(this.entity.getDataSource(), this.entityMetaData.getTypeMapping().getDropColumnTemplate(), tableName, name, "");
            }
        }
        Set createdTables = JDBCStartCommand.getCreatedTables(this.manager);
        if (this.entityMetaData.getCreateTable() && !createdTables.contains(this.entity.getEntityName())) {
            DataSource dataSource = this.entity.getDataSource();
            this.createTable(dataSource, this.entity.getQualifiedTableName(), this.getEntityCreateTableSQL(dataSource));
            if (!tableExisted) {
                this.createCMPIndices(dataSource, SQLUtil.getOldIndexes(this.entity.getQualifiedTableName(), this.entity.getDataSource()).getIndexNames());
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Indices for table " + this.entity.getQualifiedTableName() + "not created as table existed"));
            }
            if (!tableExisted) {
                this.issuePostCreateSQL(dataSource, this.entity.getMetaData().getDefaultTablePostCreateCmd(), this.entity.getQualifiedTableName());
            }
            createdTables.add(this.entity.getEntityName());
        } else {
            this.log.debug((Object)("Table not create as requested: " + this.entity.getQualifiedTableName()));
        }
        JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
            JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
            DataSource dataSource = relationMetaData.getDataSource();
            EntityBridge relatedEntity = cmrField.getRelatedEntity();
            if (!relationMetaData.isTableMappingStyle() || !createdTables.contains(relatedEntity.getEntityName())) continue;
            boolean relTableExisted = SQLUtil.tableExists(cmrField.getQualifiedTableName(), this.entity.getDataSource());
            if (relTableExisted && relationMetaData.getAlterTable()) {
                ArrayList oldNames = SQLUtil.getOldColumns(cmrField.getQualifiedTableName(), dataSource).getColumnNames();
                ArrayList<String> newNames = new ArrayList<String>();
                JDBCFieldBridge[] leftKeys = cmrField.getTableKeyFields();
                JDBCFieldBridge[] rightKeys = cmrField.getRelatedCMRField().getTableKeyFields();
                JDBCFieldBridge[] fields = new JDBCFieldBridge[leftKeys.length + rightKeys.length];
                System.arraycopy(leftKeys, 0, fields, 0, leftKeys.length);
                System.arraycopy(rightKeys, 0, fields, leftKeys.length, rightKeys.length);
                boolean different = false;
                for (int j = 0; j < fields.length; ++j) {
                    JDBCFieldBridge field = fields[j];
                    String name = field.getJDBCType().getColumnNames()[0].toUpperCase();
                    newNames.add(name);
                    if (oldNames.contains(name)) continue;
                    different = true;
                    break;
                }
                if (!different) {
                    for (String name : oldNames) {
                        if (newNames.contains(name)) continue;
                        different = true;
                        break;
                    }
                }
                if (different) {
                    this.log.error((Object)("CMR table structure is incorrect for " + cmrField.getQualifiedTableName()));
                }
            }
            if (!relationMetaData.isTableMappingStyle() || relationMetaData.isTableCreated()) continue;
            if (relationMetaData.getCreateTable()) {
                this.createTable(dataSource, cmrField.getQualifiedTableName(), this.getRelationCreateTableSQL(cmrField, dataSource));
            } else {
                this.log.debug((Object)("Relation table not created as requested: " + cmrField.getQualifiedTableName()));
            }
            this.createCMRIndex(dataSource, cmrField);
            if (!relationMetaData.getCreateTable()) continue;
            this.issuePostCreateSQL(dataSource, relationMetaData.getDefaultTablePostCreateCmd(), cmrField.getQualifiedTableName());
        }
    }

    public void addForeignKeyConstraints() throws DeploymentException {
        Set createdTables = JDBCStartCommand.getCreatedTables(this.manager);
        JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
            EntityBridge relatedEntity = cmrField.getRelatedEntity();
            JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
            if (relationMetaData.isForeignKeyMappingStyle() && createdTables.contains(relatedEntity.getEntityName())) {
                this.createCMRIndex(((JDBCAbstractEntityBridge)relatedEntity).getDataSource(), cmrField);
            }
            this.addForeignKeyConstraint(cmrField);
        }
    }

    public static Set getCreatedTables(JDBCEntityPersistenceStore manager) {
        String key = "CREATED_TABLES";
        HashSet createdTables = (HashSet)manager.getApplicationData("CREATED_TABLES");
        if (createdTables == null) {
            createdTables = new HashSet();
            manager.putApplicationData("CREATED_TABLES", createdTables);
        }
        return createdTables;
    }

    public static Set getExistedTables(JDBCEntityPersistenceStore manager) {
        String key = "EXISTED_TABLES";
        HashSet existedTables = (HashSet)manager.getApplicationData("EXISTED_TABLES");
        if (existedTables == null) {
            existedTables = new HashSet();
            manager.putApplicationData("EXISTED_TABLES", existedTables);
        }
        return existedTables;
    }

    private boolean hasIndex(SQLUtil.OldIndexes oldIndexes, JDBCFieldBridge field) {
        JDBCType jdbcType = field.getJDBCType();
        String[] columns = jdbcType.getColumnNames();
        ArrayList idxNames = oldIndexes.getIndexNames();
        ArrayList idxColumns = oldIndexes.getColumnNames();
        String indexName = null;
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            int index = this.columnIndex(idxColumns, column);
            if (index == -1) {
                return false;
            }
            if (indexName == null) {
                indexName = (String)idxNames.get(index);
                continue;
            }
            if (indexName.equals(idxNames.get(index))) continue;
            return false;
        }
        return true;
    }

    private boolean hasIndex(SQLUtil.OldIndexes oldIndexes, String column) {
        ArrayList idxColumns = oldIndexes.getColumnNames();
        return this.columnIndex(idxColumns, column) != -1;
    }

    private int columnIndex(ArrayList idxColumns, String column) {
        for (int j = 0; j < idxColumns.size(); ++j) {
            String idxColumn = (String)idxColumns.get(j);
            idxColumn = idxColumn.trim();
            while (idxColumn.startsWith("\"")) {
                idxColumn = idxColumn.substring(1);
            }
            while (idxColumn.endsWith("\"")) {
                idxColumn = idxColumn.substring(0, idxColumn.length() - 1);
            }
            if (!idxColumn.equalsIgnoreCase(column)) continue;
            return j;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void alterTable(DataSource dataSource, JDBCFunctionMappingMetaData mapping, String tableName, String fieldName, String fieldStructure) throws DeploymentException {
        Transaction oldTransaction;
        StringBuffer sqlBuf = new StringBuffer();
        mapping.getFunctionSql(new String[]{tableName, fieldName, fieldStructure}, sqlBuf);
        String sql = sqlBuf.toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Executing: " + sql));
        }
        TransactionManager tm = this.manager.getContainer().getTransactionManager();
        try {
            oldTransaction = tm.suspend();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not suspend current transaction before  alter table.", (Throwable)e);
        }
        try {
            try {
                Connection con = null;
                Statement statement = null;
                try {
                    con = dataSource.getConnection();
                    statement = con.createStatement();
                    statement.executeUpdate(sql);
                    Object var13_14 = null;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    JDBCUtil.safeClose(statement);
                    JDBCUtil.safeClose(con);
                    throw throwable;
                }
                JDBCUtil.safeClose(statement);
                JDBCUtil.safeClose(con);
                Object var15_17 = null;
            }
            catch (Exception e) {
                this.log.error((Object)("Could not alter table " + tableName + ": " + e.getMessage()));
                throw new DeploymentException("Error while alter table " + tableName + " " + sql, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            try {
                if (oldTransaction == null) throw throwable;
                tm.resume(oldTransaction);
                throw throwable;
            }
            catch (Exception e) {
                throw new DeploymentException("Could not reattach original transaction after alter table");
            }
        }
        try {}
        catch (Exception e) {
            throw new DeploymentException("Could not reattach original transaction after alter table");
        }
        if (oldTransaction != null) {
            tm.resume(oldTransaction);
        }
        if (!this.log.isDebugEnabled()) return;
        this.log.debug((Object)"Table altered successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTable(DataSource dataSource, String tableName, String sql) throws DeploymentException {
        Transaction oldTransaction;
        if (SQLUtil.tableExists(tableName, dataSource)) {
            this.log.debug((Object)("Table '" + tableName + "' already exists"));
            return;
        }
        TransactionManager tm = this.manager.getContainer().getTransactionManager();
        try {
            oldTransaction = tm.suspend();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not suspend current transaction before creating table.", (Throwable)e);
        }
        try {
            try {
                Connection con = null;
                Statement statement = null;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Executing SQL: " + sql));
                    }
                    con = dataSource.getConnection();
                    statement = con.createStatement();
                    statement.executeUpdate(sql);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    JDBCUtil.safeClose(statement);
                    JDBCUtil.safeClose(con);
                    throw throwable;
                }
                JDBCUtil.safeClose(statement);
                JDBCUtil.safeClose(con);
                Object var11_13 = null;
            }
            catch (Exception e) {
                this.log.debug((Object)("Could not create table " + tableName));
                throw new DeploymentException("Error while creating table " + tableName, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (oldTransaction == null) throw throwable;
                tm.resume(oldTransaction);
                throw throwable;
            }
            catch (Exception e) {
                throw new DeploymentException("Could not reattach original transaction after create table");
            }
        }
        try {}
        catch (Exception e) {
            throw new DeploymentException("Could not reattach original transaction after create table");
        }
        if (oldTransaction != null) {
            tm.resume(oldTransaction);
        }
        Set createdTables = (Set)this.manager.getApplicationData(CREATED_TABLES_KEY);
        createdTables.add(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createIndex(DataSource dataSource, String tableName, String indexName, String sql) throws DeploymentException {
        Transaction oldTransaction;
        TransactionManager tm = this.manager.getContainer().getTransactionManager();
        try {
            oldTransaction = tm.suspend();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not suspend current transaction before creating index.", (Throwable)e);
        }
        try {
            try {
                Connection con = null;
                Statement statement = null;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Executing SQL: " + sql));
                    }
                    con = dataSource.getConnection();
                    statement = con.createStatement();
                    statement.executeUpdate(sql);
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    JDBCUtil.safeClose(statement);
                    JDBCUtil.safeClose(con);
                    throw throwable;
                }
                JDBCUtil.safeClose(statement);
                JDBCUtil.safeClose(con);
                Object var12_14 = null;
            }
            catch (Exception e) {
                this.log.debug((Object)("Could not create index " + indexName + "on table" + tableName));
                throw new DeploymentException("Error while creating table", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                if (oldTransaction == null) throw throwable;
                tm.resume(oldTransaction);
                throw throwable;
            }
            catch (Exception e) {
                throw new DeploymentException("Could not reattach original transaction after create index");
            }
        }
        try {}
        catch (Exception e) {
            throw new DeploymentException("Could not reattach original transaction after create index");
        }
        if (oldTransaction == null) return;
        tm.resume(oldTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void issuePostCreateSQL(DataSource dataSource, List sql, String table) throws DeploymentException {
        Transaction oldTransaction;
        if (sql == null) {
            this.log.trace((Object)"issuePostCreateSQL: sql is null");
            return;
        }
        this.log.debug((Object)("issuePostCreateSQL::sql: " + sql.toString() + " on table " + table));
        TransactionManager tm = this.manager.getContainer().getTransactionManager();
        try {
            oldTransaction = tm.suspend();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not suspend current transaction before sending sql command.", (Throwable)e);
        }
        String currentCmd = "";
        try {
            try {
                Connection con = null;
                Statement statement = null;
                try {
                    con = dataSource.getConnection();
                    statement = con.createStatement();
                    for (int i = 0; i < sql.size(); ++i) {
                        currentCmd = (String)sql.get(i);
                        currentCmd = JDBCStartCommand.replaceTable(currentCmd, table);
                        currentCmd = this.replaceIndexCounter(currentCmd);
                        this.log.debug((Object)("Executing SQL: " + currentCmd));
                        statement.executeUpdate(currentCmd);
                    }
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    JDBCUtil.safeClose(statement);
                    JDBCUtil.safeClose(con);
                    throw throwable;
                }
                JDBCUtil.safeClose(statement);
                JDBCUtil.safeClose(con);
                Object var13_15 = null;
            }
            catch (Exception e) {
                this.log.warn((Object)("Issuing sql " + currentCmd + " failed: " + e.toString()));
                throw new DeploymentException("Error while issuing sql in post-table-create", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                if (oldTransaction == null) throw throwable;
                tm.resume(oldTransaction);
                throw throwable;
            }
            catch (Exception e) {
                throw new DeploymentException("Could not reattach original transaction after create index");
            }
        }
        try {}
        catch (Exception e) {
            throw new DeploymentException("Could not reattach original transaction after create index");
        }
        if (oldTransaction != null) {
            tm.resume(oldTransaction);
        }
        this.log.debug((Object)("Issued SQL  " + sql + " successfully."));
    }

    private String getEntityCreateTableSQL(DataSource dataSource) throws DeploymentException {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(this.entity.getQualifiedTableName()).append(" (");
        boolean comma = false;
        JDBCFieldBridge[] fields = this.entity.getTableFields();
        for (int i = 0; i < fields.length; ++i) {
            JDBCFieldBridge field = fields[i];
            JDBCType type = field.getJDBCType();
            if (comma) {
                sql.append(", ");
            } else {
                comma = true;
            }
            this.addField(type, sql);
        }
        if (this.entityMetaData.hasPrimaryKeyConstraint()) {
            JDBCFunctionMappingMetaData pkConstraint = this.manager.getMetaData().getTypeMapping().getPkConstraintTemplate();
            if (pkConstraint == null) {
                throw new IllegalStateException("Primary key constraint is not allowed for this type of data source");
            }
            String defTableName = this.entity.getManager().getMetaData().getDefaultTableName();
            String name = "pk_" + SQLUtil.unquote(defTableName, dataSource);
            name = SQLUtil.fixConstraintName(name, dataSource);
            Object[] args = new String[]{name, SQLUtil.getColumnNamesClause(this.entity.getPrimaryKeyFields(), new StringBuffer(100)).toString()};
            sql.append(", ");
            pkConstraint.getFunctionSql(args, sql);
        }
        return sql.append(')').toString();
    }

    private void createCMPIndices(DataSource dataSource, ArrayList indexNames) throws DeploymentException {
        JDBCFieldBridge[] cmpFields = this.entity.getTableFields();
        for (int i = 0; i < cmpFields.length; ++i) {
            JDBCFieldBridge field = cmpFields[i];
            JDBCCMPFieldMetaData fieldMD = this.entity.getMetaData().getCMPFieldByName(field.getFieldName());
            if (fieldMD == null || !fieldMD.isIndexed()) continue;
            this.createCMPIndex(dataSource, field, indexNames);
        }
        JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
        if (cmrFields != null) {
            for (int i = 0; i < cmrFields.length; ++i) {
                JDBCFieldBridge[] fkFields;
                JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
                if (!cmrField.getRelatedCMRField().getMetaData().isIndexed() || (fkFields = cmrField.getForeignKeyFields()) == null) continue;
                for (int fkInd = 0; fkInd < fkFields.length; ++fkInd) {
                    this.createCMPIndex(dataSource, fkFields[fkInd], indexNames);
                }
            }
        }
    }

    private void createCMPIndex(DataSource dataSource, JDBCFieldBridge field, ArrayList indexNames) throws DeploymentException {
        String indexName;
        boolean indexExists;
        this.log.debug((Object)("Creating index for field " + field.getFieldName()));
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE INDEX ");
        do {
            indexName = this.entity.getQualifiedTableName() + IDX_POSTFIX + this.idxCount;
            ++this.idxCount;
            indexExists = false;
            if (indexNames == null) continue;
            for (int i = 0; i < indexNames.size() && !indexExists; ++i) {
                indexExists = indexName.equalsIgnoreCase((String)indexNames.get(i));
            }
        } while (indexExists);
        sql.append(indexName);
        sql.append(" ON ");
        sql.append(this.entity.getQualifiedTableName() + " (");
        SQLUtil.getColumnNamesClause(field, sql);
        sql.append(")");
        this.createIndex(dataSource, this.entity.getQualifiedTableName(), indexName, sql.toString());
    }

    private void createCMRIndex(DataSource dataSource, JDBCAbstractCMRFieldBridge field) throws DeploymentException {
        JDBCRelationMetaData rmd = field.getMetaData().getRelationMetaData();
        if (rmd.isTableMappingStyle()) {
            String tableName = rmd.getDefaultTableName();
            this.createFKIndex(rmd.getLeftRelationshipRole(), dataSource, tableName);
            this.createFKIndex(rmd.getRightRelationshipRole(), dataSource, tableName);
        } else if (field.hasForeignKey()) {
            String tableName = field.getEntity().getQualifiedTableName();
            this.createFKIndex(field.getRelatedCMRField().getMetaData(), dataSource, tableName);
        }
    }

    private void createFKIndex(JDBCRelationshipRoleMetaData metadata, DataSource dataSource, String tableName) throws DeploymentException {
        Collection kfl = metadata.getKeyFields();
        for (JDBCCMPFieldMetaData fi : kfl) {
            if (!metadata.isIndexed()) continue;
            this.createIndex(dataSource, tableName, fi.getFieldName(), this.createIndexSQL(fi, tableName));
            ++this.idxCount;
        }
    }

    private String createIndexSQL(JDBCCMPFieldMetaData fi, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE INDEX ");
        sql.append(tableName + IDX_POSTFIX + this.idxCount);
        sql.append(" ON ");
        sql.append(tableName + " (");
        sql.append(fi.getColumnName());
        sql.append(')');
        return sql.toString();
    }

    private void addField(JDBCType type, StringBuffer sqlBuffer) throws DeploymentException {
        if (type.getAutoIncrement()[0]) {
            String columnClause = SQLUtil.getCreateTableColumnsClause(type);
            JDBCFunctionMappingMetaData autoIncrement = this.manager.getMetaData().getTypeMapping().getAutoIncrementTemplate();
            if (autoIncrement == null) {
                throw new IllegalStateException("auto-increment template not found");
            }
            Object[] args = new String[]{columnClause};
            autoIncrement.getFunctionSql(args, sqlBuffer);
        } else {
            sqlBuffer.append(SQLUtil.getCreateTableColumnsClause(type));
        }
    }

    private String getRelationCreateTableSQL(JDBCAbstractCMRFieldBridge cmrField, DataSource dataSource) throws DeploymentException {
        JDBCFieldBridge[] leftKeys = cmrField.getTableKeyFields();
        JDBCFieldBridge[] rightKeys = cmrField.getRelatedCMRField().getTableKeyFields();
        JDBCFieldBridge[] fieldsArr = new JDBCFieldBridge[leftKeys.length + rightKeys.length];
        System.arraycopy(leftKeys, 0, fieldsArr, 0, leftKeys.length);
        System.arraycopy(rightKeys, 0, fieldsArr, leftKeys.length, rightKeys.length);
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(cmrField.getQualifiedTableName()).append(" (").append(SQLUtil.getCreateTableColumnsClause(fieldsArr));
        JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
        if (relationMetaData.hasPrimaryKeyConstraint()) {
            JDBCFunctionMappingMetaData pkConstraint = this.manager.getMetaData().getTypeMapping().getPkConstraintTemplate();
            if (pkConstraint == null) {
                throw new IllegalStateException("Primary key constraint is not allowed for this type of data store");
            }
            String name = "pk_" + relationMetaData.getDefaultTableName();
            name = SQLUtil.fixConstraintName(name, dataSource);
            Object[] args = new String[]{name, SQLUtil.getColumnNamesClause(fieldsArr, new StringBuffer(100).toString(), new StringBuffer()).toString()};
            sql.append(", ");
            pkConstraint.getFunctionSql(args, sql);
        }
        sql.append(')');
        return sql.toString();
    }

    private void addForeignKeyConstraint(JDBCAbstractCMRFieldBridge cmrField) throws DeploymentException {
        JDBCRelationshipRoleMetaData metaData = cmrField.getMetaData();
        if (metaData.hasForeignKeyConstraint()) {
            if (metaData.getRelationMetaData().isTableMappingStyle()) {
                this.addForeignKeyConstraint(metaData.getRelationMetaData().getDataSource(), cmrField.getQualifiedTableName(), cmrField.getFieldName(), cmrField.getTableKeyFields(), cmrField.getEntity().getQualifiedTableName(), cmrField.getEntity().getPrimaryKeyFields());
            } else if (cmrField.hasForeignKey()) {
                JDBCAbstractEntityBridge relatedEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
                this.addForeignKeyConstraint(cmrField.getEntity().getDataSource(), cmrField.getEntity().getQualifiedTableName(), cmrField.getFieldName(), cmrField.getForeignKeyFields(), relatedEntity.getQualifiedTableName(), relatedEntity.getPrimaryKeyFields());
            }
        } else {
            this.log.debug((Object)("Foreign key constraint not added as requested: relationshipRolename=" + metaData.getRelationshipRoleName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addForeignKeyConstraint(DataSource dataSource, String tableName, String cmrFieldName, JDBCFieldBridge[] fields, String referencesTableName, JDBCFieldBridge[] referencesFields) throws DeploymentException {
        Transaction oldTransaction;
        Set createdTables = (Set)this.manager.getApplicationData(CREATED_TABLES_KEY);
        if (!createdTables.contains(tableName)) {
            return;
        }
        JDBCFunctionMappingMetaData fkConstraint = this.manager.getMetaData().getTypeMapping().getFkConstraintTemplate();
        if (fkConstraint == null) {
            throw new IllegalStateException("Foreign key constraint is not allowed for this type of datastore");
        }
        String a = SQLUtil.getColumnNamesClause(fields, new StringBuffer(50)).toString();
        String b = SQLUtil.getColumnNamesClause(referencesFields, new StringBuffer(50)).toString();
        Object[] args = new String[]{tableName, SQLUtil.fixConstraintName("fk_" + tableName + "_" + cmrFieldName, dataSource), a, referencesTableName, b};
        String sql = fkConstraint.getFunctionSql(args, new StringBuffer(100)).toString();
        TransactionManager tm = this.manager.getContainer().getTransactionManager();
        try {
            oldTransaction = tm.suspend();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not suspend current transaction before alter table create foreign key.", (Throwable)e);
        }
        try {
            try {
                Connection con = null;
                Statement statement = null;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Executing SQL: " + sql));
                    }
                    con = dataSource.getConnection();
                    statement = con.createStatement();
                    statement.executeUpdate(sql);
                    Object var18_19 = null;
                }
                catch (Throwable throwable) {
                    Object var18_20 = null;
                    JDBCUtil.safeClose(statement);
                    JDBCUtil.safeClose(con);
                    throw throwable;
                }
                JDBCUtil.safeClose(statement);
                JDBCUtil.safeClose(con);
                Object var20_22 = null;
            }
            catch (Exception e) {
                this.log.warn((Object)("Could not add foreign key constraint: table=" + tableName));
                throw new DeploymentException("Error while adding foreign key constraint", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            try {
                if (oldTransaction == null) throw throwable;
                tm.resume(oldTransaction);
                throw throwable;
            }
            catch (Exception e) {
                throw new DeploymentException("Could not reattach original transaction after create table");
            }
        }
        try {}
        catch (Exception e) {
            throw new DeploymentException("Could not reattach original transaction after create table");
        }
        if (oldTransaction == null) return;
        tm.resume(oldTransaction);
    }

    private static String replaceTable(String in, String table) {
        int pos = in.indexOf("%%t");
        if (pos == -1) {
            return in;
        }
        String first = in.substring(0, pos);
        String last = in.substring(pos + 3);
        return first + table + last;
    }

    private String replaceIndexCounter(String in) {
        int pos = in.indexOf("%%n");
        if (pos == -1) {
            return in;
        }
        String first = in.substring(0, pos);
        String last = in.substring(pos + 3);
        ++this.idxCount;
        return first + this.idxCount + last;
    }
}

