/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.UITogglePanel;
import org.richfaces.event.SwitchablePanelSwitchEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TogglePanelRenderer
extends RendererBase {
    private static final String CLIENT_SCRIPT = "<script type=\"text/javascript\">TogglePanelManager.add(new TogglePanel(\"{0}\", $A([\"{1}\"]), \"{2}\"));</script>";

    protected Class<? extends UIComponent> getComponentClass() {
        return UITogglePanel.class;
    }

    public void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        Map rqMap = context.getExternalContext().getRequestParameterMap();
        Object clnId = rqMap.get(component.getClientId(context));
        UITogglePanel panel = (UITogglePanel)component;
        if (clnId != null && "client".equals(panel.getSwitchType())) {
            new SwitchablePanelSwitchEvent((UIComponent)panel, clnId, null).queue();
        }
    }

    private UIComponent getFacet(UITogglePanel togglePanel, String facetName) {
        UIComponent child = togglePanel.getFacet(facetName);
        if (child == null) {
            throw new FacesException("Facet with name: " + facetName + " not found!");
        }
        return child;
    }

    public void handleFacets(FacesContext context, UITogglePanel component) throws IOException {
        UITogglePanel panel = component;
        List<String> stateOrderList = component.getStateOrderList();
        String state = (String)component.getValue();
        if (state == null) {
            String initialState = component.getInitialState();
            if (initialState != null) {
                state = initialState;
            } else if (!stateOrderList.isEmpty()) {
                state = stateOrderList.get(0);
            } else {
                throw new FacesException("The \"initialState\" attribute of the togglePanel component should be set if \"stateOrder\" attribute is empty!");
            }
        }
        ResponseWriter out = context.getResponseWriter();
        String switchType = panel.getSwitchType();
        if ("client".equals(switchType)) {
            String panelId = panel.getClientId(context);
            StringBuffer divIds = new StringBuffer();
            boolean first = true;
            for (String stateName : stateOrderList) {
                UIComponent child = this.getFacet(component, stateName);
                if (!first) {
                    divIds.append("\", \"");
                }
                divIds.append(stateName);
                first = false;
                String id = panel.getClientId(context) + "_" + stateName;
                out.startElement("div", (UIComponent)component);
                out.writeAttribute("id", (Object)id, null);
                out.writeAttribute("style", (Object)("display: " + (stateName.equals(state) ? "inherit" : "none")), null);
                this.renderChild(context, child);
                out.endElement("div");
            }
            String idInput = panel.getClientId(context) + "_input";
            out.startElement("div", (UIComponent)component);
            out.writeAttribute("style", (Object)"display: none;", null);
            out.startElement("input", (UIComponent)component);
            out.writeAttribute("type", (Object)"hidden", null);
            out.writeAttribute("autocomplete", (Object)"off", null);
            out.writeAttribute("id", (Object)idInput, null);
            out.writeAttribute("name", (Object)panel.getClientId(context), null);
            out.writeAttribute("value", (Object)state, null);
            out.endElement("input");
            out.endElement("div");
            String script = MessageFormat.format(CLIENT_SCRIPT, panelId, divIds.toString(), state);
            out.write(script);
        } else {
            UIComponent child = this.getFacet(component, state);
            if (child != null) {
                out.startElement("div", (UIComponent)component);
                this.renderChild(context, child);
                out.endElement("div");
            }
        }
        panel.setValue(state);
    }

    public boolean getRendersChildren() {
        return true;
    }
}

