/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.Logger;
import org.apache.log.format.PatternFormatter;
import org.apache.log.util.StackIntrospector;

public class ExtendedPatternFormatter
extends PatternFormatter {
    private static final int TYPE_METHOD = 9;
    private static final int TYPE_THREAD = 10;
    private static final String TYPE_METHOD_STR = "method";
    private static final String TYPE_THREAD_STR = "thread";
    private int m_callStackOffset = 0;

    public ExtendedPatternFormatter(String format) {
        this(format, 0);
    }

    public ExtendedPatternFormatter(String format, int callStackOffset) {
        super(format);
        this.m_callStackOffset = callStackOffset;
    }

    @Override
    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_METHOD_STR)) {
            return 9;
        }
        if (type.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 10;
        }
        return super.getTypeIdFor(type);
    }

    @Override
    protected String formatPatternRun(LogEvent event, PatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getMethod(event, run.m_format);
            }
            case 10: {
                return this.getThread(event, run.m_format);
            }
        }
        return super.formatPatternRun(event, run);
    }

    private String getMethod(LogEvent event, String format) {
        Object object;
        ContextMap map = event.getContextMap();
        if (null != map && null != (object = map.get(TYPE_METHOD_STR))) {
            return object.toString();
        }
        Class clazz = StackIntrospector.getCallerClass(Logger.class, this.m_callStackOffset - 1);
        if (null == clazz) {
            return "UnknownMethod";
        }
        String result = StackIntrospector.getCallerMethod(clazz);
        if (null == result) {
            return "UnknownMethod";
        }
        return result;
    }

    private String getThread(LogEvent event, String format) {
        Object object;
        ContextMap map = event.getContextMap();
        if (null != map && null != (object = map.get(TYPE_THREAD_STR))) {
            return object.toString();
        }
        return Thread.currentThread().getName();
    }
}

