/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Channel;

public class WaitFreeQueue
implements Channel {
    protected volatile Node head;
    protected volatile Node tail;
    protected final Object tailLock;

    public WaitFreeQueue() {
        this.tail = this.head = new Node(null);
        this.tailLock = new Object();
    }

    protected synchronized boolean CASHead(Node oldHead, Node newHead) {
        if (this.head == oldHead) {
            this.head = newHead;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean CASTail(Node oldTail, Node newTail) {
        Object object = this.tailLock;
        synchronized (object) {
            if (this.tail == oldTail) {
                this.tail = newTail;
                return true;
            }
            return false;
        }
    }

    @Override
    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Node n = new Node(x);
        while (true) {
            Node t;
            if ((t = this.tail).CASNext(null, n)) {
                this.CASTail(t, n);
                return;
            }
            this.CASTail(t, t.next);
        }
    }

    @Override
    public boolean offer(Object x, long msecs) throws InterruptedException {
        this.put(x);
        return true;
    }

    protected Object extract() throws InterruptedException {
        Object result;
        Node first;
        Node h;
        do {
            h = this.head;
            first = h.next;
            if (first == null) {
                return null;
            }
            result = first.value;
        } while (!this.CASHead(h, first));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object peek() {
        Node first = this.head.next;
        if (first == null) {
            return null;
        }
        WaitFreeQueue waitFreeQueue = this;
        synchronized (waitFreeQueue) {
            return first.value;
        }
    }

    @Override
    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x;
        while ((x = this.extract()) == null) {
            Thread.sleep(0L);
        }
        return x;
    }

    @Override
    public Object poll(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (msecs <= 0L) {
            return this.extract();
        }
        long startTime = System.currentTimeMillis();
        Object x;
        while ((x = this.extract()) == null) {
            if (System.currentTimeMillis() - startTime >= msecs) {
                return null;
            }
            Thread.sleep(0L);
        }
        return x;
    }

    protected static final class Node {
        protected final Object value;
        protected volatile Node next;

        protected Node(Object x) {
            this.value = x;
        }

        protected synchronized boolean CASNext(Node oldNext, Node newNext) {
            if (this.next == oldNext) {
                this.next = newNext;
                return true;
            }
            return false;
        }
    }
}

