/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.security.integration.SecurityDomainObjectFactory;

@ManagementObject(name="JNDIContextEstablishment", componentType=@ManagementComponent(type="MCBean", subtype="Security"))
public class JNDIContextEstablishment {
    private Logger log = Logger.getLogger(JNDIContextEstablishment.class);
    protected String baseContext = "java:/jaas";
    private String factoryName = SecurityDomainObjectFactory.class.getName();

    public JNDIContextEstablishment() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.log.trace((Object)"Error in initialization of JNDIContextEstablishment", (Throwable)e);
        }
    }

    public void setBaseContext(String ctx) throws Exception {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is null");
        }
        this.baseContext = ctx;
        this.initialize();
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.log.trace((Object)"Error in initialization of JNDIContextEstablishment", (Throwable)e);
        }
    }

    private void initialize() throws Exception {
        InitialContext ctx = new InitialContext();
        StringRefAddr refAddr = new StringRefAddr("nns", "JSM");
        Reference ref = new Reference("javax.naming.Context", refAddr, this.factoryName, null);
        ctx.rebind(this.baseContext, (Object)ref);
    }
}

