/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss4;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.asintegration.jboss4.JBossClassPool;
import org.jboss.aop.asintegration.jboss4.ScopedJBossClassPool;
import org.jboss.aop.asintegration.jboss4.ScopedRepositoryClassLoaderHelper;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.AbstractJBossClassPoolFactory;
import org.jboss.mx.loading.RepositoryClassLoader;

public class JBossClassPoolFactory
extends AbstractJBossClassPoolFactory
implements ScopedClassPoolFactory {
    protected File tmpClassesDir;

    public JBossClassPoolFactory(File tmpClassesDir) throws IOException {
        this.tmpClassesDir = tmpClassesDir;
    }

    public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        ClassPool parent = this.getCreateParentClassPools(cl, src, repository);
        if (cl instanceof RepositoryClassLoader) {
            URL tmpCP;
            File tempdir = this.getTempDirectory(cl);
            try {
                tmpCP = this.createURLAndAddToLoader(cl, tempdir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (ScopedRepositoryClassLoaderHelper.isScopedClassLoader(cl)) {
                return new ScopedJBossClassPool(cl, parent, repository, tempdir, tmpCP);
            }
            return new JBossClassPool(cl, parent, repository, tempdir, tmpCP);
        }
        return new AOPClassPool(cl, parent, repository);
    }

    protected File getTempDirectory(ClassLoader cl) {
        File tempdir = null;
        int attempts = 0;
        IOException ex = null;
        while (tempdir == null && attempts < 5) {
            try {
                tempdir = this.createTempDir(cl);
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (tempdir == null) {
            throw new RuntimeException("", ex);
        }
        return tempdir;
    }

    public File createTempDir(ClassLoader cl) throws IOException {
        File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
        tempdir.delete();
        tempdir.mkdir();
        tempdir.deleteOnExit();
        return tempdir;
    }

    private URL createURLAndAddToLoader(ClassLoader cl, File tempdir) throws IOException {
        URL tmpURL = tempdir.toURL();
        URL tmpCP = new URL(tmpURL, "?dynamic=true");
        RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
        if (ucl.getLoaderRepository() != null) {
            ucl.addURL(tmpCP);
        }
        return tmpCP;
    }
}

