/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.rhq.core.domain.configuration.PropertySimple;

public class TextareaMapConverter
implements Converter {
    private static final String ATTRIBUTE_VALUE_SEPARATOR = "=";
    private static final String LINE_SEPARATOR = "\n";

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String valueAsString) {
        HashMap<String, PropertySimple> valueAsMap = null;
        if (valueAsString != null && !valueAsString.trim().equals("")) {
            String[] lines = valueAsString.split(LINE_SEPARATOR);
            valueAsMap = new HashMap<String, PropertySimple>();
            for (String line : lines) {
                if (line == null || line.trim().equals("")) continue;
                String[] attributeValuePair = (line = line.trim()).split(ATTRIBUTE_VALUE_SEPARATOR, 2);
                if (attributeValuePair.length == 2 && attributeValuePair[0] != null && !attributeValuePair[0].equals("")) {
                    PropertySimple property = new PropertySimple(attributeValuePair[0], (Object)attributeValuePair[1].trim());
                    valueAsMap.put(attributeValuePair[0], property);
                    continue;
                }
                FacesMessage message = new FacesMessage();
                message.setDetail("Invalid attribute/value pair read :" + line);
                message.setSummary("Invalid attribute/value pair read :" + line);
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                throw new ConverterException(message);
            }
        }
        return valueAsMap;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object valueAsMap) {
        String valueAsString = null;
        if (valueAsMap != null && valueAsMap instanceof Map) {
            Map map = (Map)valueAsMap;
            StringBuffer mapAsStringBuffer = new StringBuffer();
            for (String attributeName : map.keySet()) {
                PropertySimple attributeValue = (PropertySimple)map.get(attributeName);
                mapAsStringBuffer.append(attributeName).append(ATTRIBUTE_VALUE_SEPARATOR).append(attributeValue.getStringValue()).append(LINE_SEPARATOR);
            }
            valueAsString = mapAsStringBuffer.toString();
        }
        return valueAsString;
    }
}

