/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.W3CAddressingConstants;
import com.sun.xml.ws.addressing.WsaPropertyBag;
import com.sun.xml.ws.addressing.WsaTube;
import com.sun.xml.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.message.FaultDetailHeader;
import com.sun.xml.ws.resources.AddressingMessages;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;

public class WsaServerTube
extends WsaTube {
    private WSEndpoint endpoint;
    private WSEndpointReference replyTo;
    private WSEndpointReference faultTo;
    private boolean isAnonymousRequired = false;
    private WSDLBoundOperation wbo;
    public static final String REQUEST_MESSAGE_ID = "com.sun.xml.ws.addressing.request.messageID";
    private static final Logger LOGGER = Logger.getLogger(WsaServerTube.class.getName());

    public WsaServerTube(WSEndpoint endpoint, @NotNull WSDLPort wsdlPort, WSBinding binding, Tube next) {
        super(wsdlPort, binding, next);
        this.endpoint = endpoint;
    }

    public WsaServerTube(WsaServerTube that, TubeCloner cloner) {
        super(that, cloner);
        this.endpoint = that.endpoint;
    }

    @Override
    public WsaServerTube copy(TubeCloner cloner) {
        return new WsaServerTube(this, cloner);
    }

    @Override
    @NotNull
    public NextAction processRequest(Packet request) {
        Packet p;
        Message msg = request.getMessage();
        if (msg == null) {
            return this.doInvoke(this.next, request);
        }
        request.addSatellite(new WsaPropertyBag(this.addressingVersion, this.soapVersion, request));
        HeaderList hl = request.getMessage().getHeaders();
        try {
            this.replyTo = hl.getReplyTo(this.addressingVersion, this.soapVersion);
            this.faultTo = hl.getFaultTo(this.addressingVersion, this.soapVersion);
        }
        catch (InvalidAddressingHeaderException e) {
            LOGGER.log(Level.WARNING, this.addressingVersion.getInvalidMapText() + ", Problem header:" + e.getProblemHeader() + ", Reason: " + e.getSubsubcode(), e);
            SOAPFault soapFault = this.helper.createInvalidAddressingHeaderFault(e, this.addressingVersion);
            if (this.wsdlPort != null && request.getMessage().isOneWay(this.wsdlPort)) {
                Packet response = request.createServerResponse(null, this.wsdlPort, null, this.binding);
                return this.doReturnWith(response);
            }
            Message m = Messages.create(soapFault);
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                FaultDetailHeader s11FaultDetailHeader = new FaultDetailHeader(this.addressingVersion, this.addressingVersion.problemHeaderQNameTag.getLocalPart(), e.getProblemHeader());
                m.getHeaders().add(s11FaultDetailHeader);
            }
            Packet response = request.createServerResponse(m, this.wsdlPort, null, this.binding);
            return this.doReturnWith(response);
        }
        if (this.replyTo == null) {
            this.replyTo = this.addressingVersion.anonymousEpr;
        }
        if (this.faultTo == null) {
            this.faultTo = this.replyTo;
        }
        this.wbo = this.getWSDLBoundOperation(request);
        if (this.wbo != null && this.wbo.getAnonymous() == WSDLBoundOperation.ANONYMOUS.required) {
            this.isAnonymousRequired = true;
        }
        if ((p = this.validateInboundHeaders(request)).getMessage() == null) {
            return this.doReturnWith(p);
        }
        if (p.getMessage().isFault()) {
            if (!this.isAnonymousRequired && !this.faultTo.isAnonymous() && request.transportBackChannel != null) {
                request.transportBackChannel.close();
            }
            return this.processResponse(p);
        }
        if (!(this.isAnonymousRequired || this.replyTo.isAnonymous() || this.faultTo.isAnonymous() || request.transportBackChannel == null)) {
            request.transportBackChannel.close();
        }
        return this.doInvoke(this.next, p);
    }

    @Override
    @NotNull
    public NextAction processResponse(Packet response) {
        WSEndpointReference target;
        Message msg = response.getMessage();
        if (msg == null) {
            return this.doReturnWith(response);
        }
        WSEndpointReference wSEndpointReference = target = msg.isFault() ? this.faultTo : this.replyTo;
        if (target.isAnonymous() || this.isAnonymousRequired) {
            return this.doReturnWith(response);
        }
        if (target.isNone()) {
            response.setMessage(null);
            return this.doReturnWith(response);
        }
        this.processNonAnonymousReply(response, target);
        response.setMessage(null);
        return this.doReturnWith(response);
    }

    private void processNonAnonymousReply(Packet packet, WSEndpointReference target) {
        String action;
        EndpointAddress adrs;
        if (packet.transportBackChannel != null) {
            packet.transportBackChannel.close();
        }
        if (this.wsdlPort != null && packet.getMessage().isOneWay(this.wsdlPort)) {
            LOGGER.fine(AddressingMessages.NON_ANONYMOUS_RESPONSE_ONEWAY());
            return;
        }
        try {
            adrs = new EndpointAddress(URI.create(target.getAddress()));
        }
        catch (NullPointerException e) {
            throw new WebServiceException(e);
        }
        catch (IllegalArgumentException e) {
            throw new WebServiceException(e);
        }
        Tube transport = TransportTubeFactory.create(Thread.currentThread().getContextClassLoader(), new ClientTubeAssemblerContext(adrs, this.wsdlPort, null, this.binding, this.endpoint.getContainer()));
        packet.endpointAddress = adrs;
        packet.soapAction = action = packet.getMessage().isFault() ? this.helper.getFaultAction(this.wbo, packet) : this.helper.getOutputAction(this.wbo);
        packet.expectReply = false;
        Fiber.current().runSync(transport, packet);
    }

    @Override
    protected void validateAction(Packet packet) {
        WSDLBoundOperation wbo = this.getWSDLBoundOperation(packet);
        if (wbo == null) {
            return;
        }
        String gotA = packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
        if (gotA == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_SERVER_NULL_ACTION());
        }
        String expected = this.helper.getInputAction(packet);
        String soapAction = this.helper.getSOAPAction(packet);
        if (this.helper.isInputActionDefault(packet) && soapAction != null && !soapAction.equals("")) {
            expected = soapAction;
        }
        if (expected != null && !gotA.equals(expected)) {
            throw new ActionNotSupportedException(gotA);
        }
    }

    @Override
    protected void checkMessageAddressingProperties(Packet packet) {
        super.checkMessageAddressingProperties(packet);
        WSDLBoundOperation wbo = this.getWSDLBoundOperation(packet);
        this.checkAnonymousSemantics(wbo, this.replyTo, this.faultTo);
        this.checkNonAnonymousAddresses(this.replyTo, this.faultTo);
    }

    private void checkNonAnonymousAddresses(WSEndpointReference replyTo, WSEndpointReference faultTo) {
        if (!replyTo.isAnonymous()) {
            try {
                new EndpointAddress(URI.create(replyTo.getAddress()));
            }
            catch (Exception e) {
                throw new InvalidAddressingHeaderException(this.addressingVersion.replyToTag, this.addressingVersion.invalidAddressTag);
            }
        }
    }

    final void checkAnonymousSemantics(WSDLBoundOperation wbo, WSEndpointReference replyTo, WSEndpointReference faultTo) {
        if (this.addressingVersion == null || this.addressingVersion == AddressingVersion.MEMBER) {
            return;
        }
        if (wbo == null) {
            return;
        }
        WSDLBoundOperation.ANONYMOUS anon = wbo.getAnonymous();
        String replyToValue = null;
        String faultToValue = null;
        if (replyTo != null) {
            replyToValue = replyTo.getAddress();
        }
        if (faultTo != null) {
            faultToValue = faultTo.getAddress();
        }
        switch (anon) {
            case optional: {
                break;
            }
            case prohibited: {
                if (replyToValue != null && replyToValue.equals(this.addressingVersion.anonymousUri)) {
                    throw new InvalidAddressingHeaderException(this.addressingVersion.replyToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (faultToValue == null || !faultToValue.equals(this.addressingVersion.anonymousUri)) break;
                throw new InvalidAddressingHeaderException(this.addressingVersion.faultToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
            }
            case required: {
                if (replyToValue != null && !replyToValue.equals(this.addressingVersion.anonymousUri)) {
                    throw new InvalidAddressingHeaderException(this.addressingVersion.replyToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (faultToValue == null || faultToValue.equals(this.addressingVersion.anonymousUri)) break;
                throw new InvalidAddressingHeaderException(this.addressingVersion.faultToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
            }
            default: {
                throw new WebServiceException(AddressingMessages.INVALID_WSAW_ANONYMOUS(anon.toString()));
            }
        }
    }
}

